/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.devezhao.commons.DateFormatUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class CalendarUtils
extends DateFormatUtils {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final Date DATE_20991231 = new GregorianCalendar(2099, 11, 31).getTime();

    public static Calendar getInstance() {
        return Calendar.getInstance(DEFAULT_TIME_ZONE, DEFAULT_LOCALE);
    }

    public static Calendar getInstance(Date date) {
        Calendar cal = CalendarUtils.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date now() {
        return CalendarUtils.getInstance().getTime();
    }

    public static Date addDay(int amount) {
        return CalendarUtils.add(amount, 5);
    }

    public static Date addMonth(int amount) {
        return CalendarUtils.add(amount, 2);
    }

    public static Date add(int amount, int field) {
        Calendar cal = CalendarUtils.getInstance();
        cal.add(field, amount);
        return cal.getTime();
    }

    public static Date addDay(Date date, int amount) {
        return CalendarUtils.add(date, amount, 5);
    }

    public static Date addMonth(Date date, int amount) {
        return CalendarUtils.add(date, amount, 2);
    }

    public static Date add(Date date, int amount, int field) {
        Calendar cal = CalendarUtils.getInstance(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static void clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void fullTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    public static Date clearTime(Date date) {
        Calendar cal = CalendarUtils.getInstance(date);
        CalendarUtils.clearTime(cal);
        return cal.getTime();
    }

    public static Date fullTime(Date date) {
        Calendar cal = CalendarUtils.getInstance(date);
        CalendarUtils.fullTime(cal);
        return cal.getTime();
    }

    public static boolean isSameMonth(Date date, Date another) {
        return CalendarUtils.isSameMonth(date, another, false);
    }

    public static boolean isSameMonth(Date date, Date another, boolean absolute) {
        Calendar cal1 = CalendarUtils.getInstance(date);
        Calendar cal2 = CalendarUtils.getInstance(another);
        if (!absolute) {
            return cal1.get(2) == cal2.get(2);
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameDay(Date date, Date another) {
        return CalendarUtils.isSameDay(date, another, false);
    }

    public static boolean isSameDay(Date date, Date another, boolean absolute) {
        Calendar cal1 = CalendarUtils.getInstance(date);
        Calendar cal2 = CalendarUtils.getInstance(another);
        if (!absolute) {
            return cal1.get(5) == cal2.get(5);
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static int getDayLeft(Date end) {
        return CalendarUtils.getDayLeft(CalendarUtils.now(), end);
    }

    public static int getDayLeft(Date begin, Date end) {
        int ct = (begin = CalendarUtils.clearTime(begin)).compareTo(end = CalendarUtils.clearTime(end));
        if (ct == 0) {
            return 0;
        }
        if (ct < 0) {
            Calendar cal = CalendarUtils.getInstance(begin);
            int days = -1;
            while (cal.getTime().compareTo(end) <= 0) {
                ++days;
                cal.add(6, 1);
            }
            return days;
        }
        Calendar cal = CalendarUtils.getInstance(end);
        int days = -1;
        while (cal.getTime().compareTo(begin) <= 0) {
            ++days;
            cal.add(6, 1);
        }
        return -days;
    }

    public static Date parse(String source) {
        if (StringUtils.isBlank((String)source)) {
            return null;
        }
        int len = source.trim().length();
        if (len == 8) {
            return CalendarUtils.parse(source, CalendarUtils.getPlainDateFormat());
        }
        if (len == 14) {
            return CalendarUtils.parse(source, CalendarUtils.getPlainDateTimeFormat());
        }
        if (len == 10) {
            return CalendarUtils.parse(source, CalendarUtils.getUTCDateFormat());
        }
        if (len == 19) {
            return CalendarUtils.parse(source, CalendarUtils.getUTCDateTimeFormat());
        }
        if (len == 11) {
            return CalendarUtils.parse(source, CalendarUtils.getCNDateFormat());
        }
        if (len == 21) {
            return CalendarUtils.parse(source, CalendarUtils.getCNDateTimeFormat());
        }
        return null;
    }

    public static Date parse(String source, DateFormat format) {
        try {
            return format.parse(source);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Date parse(String source, String format) {
        return CalendarUtils.parse(source, CalendarUtils.getDateFormat(format));
    }
}

