/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security;

import cn.devezhao.bizz.BizzException;
import cn.devezhao.bizz.privileges.DepthEntry;
import cn.devezhao.bizz.privileges.Privileges;
import cn.devezhao.bizz.privileges.impl.BizzDepthEntry;
import cn.devezhao.bizz.privileges.impl.BizzPermission;
import cn.devezhao.bizz.security.AccessDeniedException;
import cn.devezhao.bizz.security.QueryFilter;
import cn.devezhao.bizz.security.member.BusinessUnit;
import cn.devezhao.bizz.security.member.Role;
import cn.devezhao.bizz.security.member.User;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

public class EntityQueryFilter
implements QueryFilter {
    private static final String F_OwnUser;
    private static final String F_OwnBizUnit;
    private static final String V_RootUser;
    private static final String V_RootRole;
    public static final QueryFilter DENIED;
    public static final QueryFilter ALLOWED;
    static final String FV_FORMAT = "( {0} = ''{1}'' )";
    protected final User user;
    protected final Role role;

    public EntityQueryFilter(User user) {
        this(user, user.getOwningRole());
    }

    public EntityQueryFilter(User user, Role role) {
        this.user = user;
        this.role = role;
    }

    @Override
    public String evaluate(int entity) {
        Privileges p;
        if (this.role.getIdentity().toString().equals(V_RootRole) || this.user.getIdentity().toString().equals(V_RootUser)) {
            return ALLOWED.evaluate(entity);
        }
        try {
            p = this.role.getPrivileges(Integer.valueOf(entity));
        }
        catch (AccessDeniedException denied) {
            return DENIED.evaluate(entity);
        }
        DepthEntry de = p.superlative(BizzPermission.READ);
        if (de == BizzDepthEntry.GLOBAL) {
            return ALLOWED.evaluate(entity);
        }
        StringBuffer filter = new StringBuffer();
        if (de == BizzDepthEntry.PRIVATE) {
            filter.append(MessageFormat.format(FV_FORMAT, F_OwnUser, this.user.getIdentity()));
            return this.evaluate(entity, filter);
        }
        if (de == BizzDepthEntry.LOCAL) {
            filter.append(MessageFormat.format(FV_FORMAT, F_OwnBizUnit, this.user.getOwningBizUnit().getIdentity()));
            return this.evaluate(entity, filter);
        }
        if (de == BizzDepthEntry.DEEPDOWN) {
            BusinessUnit biz = this.user.getOwningBizUnit();
            filter.append("( ");
            filter.append(MessageFormat.format(FV_FORMAT, F_OwnBizUnit, biz.getIdentity()));
            for (BusinessUnit cBiz : biz.getChildren()) {
                filter.append(" OR ").append(MessageFormat.format(FV_FORMAT, F_OwnBizUnit, cBiz.getIdentity()));
            }
            return this.evaluate(entity, filter.append(" )"));
        }
        return DENIED.evaluate(entity);
    }

    protected String evaluate(int entity, StringBuffer filtered) {
        return filtered.toString();
    }

    static {
        String cfgFile = "bizz.properties";
        InputStream in = EntityQueryFilter.class.getClassLoader().getResourceAsStream(cfgFile);
        if (in == null) {
            in = EntityQueryFilter.class.getClassLoader().getResourceAsStream("cn/devezhao/bizz/bizz-default.properties");
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new BizzException("Cannot load config file!", e);
        }
        F_OwnUser = props.getProperty("field.own-user");
        F_OwnBizUnit = props.getProperty("field.own-biz-unit");
        V_RootUser = props.getProperty("value.root-user");
        V_RootRole = props.getProperty("value.root-role");
        DENIED = entity -> "( 1 = 0 )";
        ALLOWED = entity -> "( 1 = 1 )";
    }
}

