/*
 * Decompiled with CFR 0.152.
 */
package com.resources.view.textbox;

import android.content.Context;
import android.graphics.Canvas;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatEditText;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.example.resources.R;
import com.jakewharton.rxbinding2.widget.RxTextView;
import java.util.List;
import rx.Observable;

public class SimpleCatalogEditText<T>
extends AppCompatEditText {
    CharSequence mHint = this.getHint();
    OnCatalogSelectedListener<T> onCatalogSelectedListener;
    ListAdapter mSpinnerAdapter;
    public List<T> mItems;
    private T mSelectedObject;

    public SimpleCatalogEditText(Context context) {
        super(context);
    }

    public SimpleCatalogEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SimpleCatalogEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setCatalogs(List<T> catalogs) {
        this.mItems = catalogs;
        this.setAdapter((ListAdapter)new ArrayAdapter(this.getContext(), 17367043, this.mItems));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setFocusable(false);
        this.setClickable(true);
    }

    public void setAdapter(ListAdapter adapter) {
        this.mSpinnerAdapter = adapter;
        this.configureOnClickListener();
    }

    private void configureOnClickListener() {
        this.setOnClickListener(view -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
            View dialogView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_catalog_edit_text, null);
            TextView titleTextView = (TextView)dialogView.findViewById(R.id.v_catalog_edit_text_title);
            final ListView listView = (ListView)dialogView.findViewById(R.id.v_catalog_edit_text_list);
            EditText searchEditText = (EditText)dialogView.findViewById(R.id.v_catalog_edit_text_search);
            titleTextView.setText(this.mHint);
            listView.setAdapter(this.mSpinnerAdapter);
            builder.setView(dialogView);
            builder.setPositiveButton(R.string.dialog_cancel, null);
            final AlertDialog dialog = builder.create();
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    Object object = listView.getAdapter().getItem(position);
                    SimpleCatalogEditText.this.mSelectedObject = object;
                    SimpleCatalogEditText.this.setText(object.toString());
                    if (SimpleCatalogEditText.this.onCatalogSelectedListener != null) {
                        SimpleCatalogEditText.this.onCatalogSelectedListener.onItemCatalogSelectedListener(object, position);
                    }
                    dialog.dismiss();
                }
            });
            RxTextView.afterTextChangeEvents((TextView)searchEditText).subscribe(event -> {
                String search = event.view().getText().toString().trim();
                if (TextUtils.isEmpty((CharSequence)search)) {
                    listView.setAdapter((ListAdapter)new ArrayAdapter(this.getContext(), 17367043, this.mItems));
                } else {
                    Observable.from(this.mItems).filter(t -> t.toString().toLowerCase().contains(search.toLowerCase())).toList().subscribe(ts -> listView.setAdapter((ListAdapter)new ArrayAdapter(this.getContext(), 17367043, ts)));
                }
            });
            dialog.show();
        });
    }

    public void setOnCatalogSelectedListener(OnCatalogSelectedListener<T> onCatalogSelectedListener) {
        this.onCatalogSelectedListener = onCatalogSelectedListener;
    }

    public void setSelectedObject(T object) {
        if (object != null) {
            this.mSelectedObject = object;
            this.setText(object.toString());
        }
    }

    public T getSelectedValue() {
        return this.mSelectedObject;
    }

    public static interface OnCatalogSelectedListener<T> {
        public void onItemCatalogSelectedListener(T var1, int var2);
    }
}

