/*
 * Decompiled with CFR 0.152.
 */
package com.resources.view.recicler;

import android.graphics.Rect;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.resources.view.recicler.BaseSimpleAdapter;
import com.resources.view.recicler.RefreshBaseRecyclerCallback;
import java.util.List;

public class BaseSimpleRecyclerView {
    public RecyclerView recyclerView;
    public BaseSimpleAdapter adapter;
    public LinearLayoutManager layout;
    private RefreshBaseRecyclerCallback mRefreshBaseReclycer;
    public SwipeRefreshLayout mSwipeRefreshLayout;
    private ViewGroup emptyView;
    private View parentView;

    public BaseSimpleRecyclerView(View parentView, int recyclerViewId, int swipeRefreshLayoutId) {
        this.parentView = parentView;
        this.recyclerView = (RecyclerView)parentView.findViewById(recyclerViewId);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(parentView.getContext()));
        BottomOffsetDecoration bottomOffsetDecoration = new BottomOffsetDecoration(200);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)bottomOffsetDecoration);
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)parentView.findViewById(swipeRefreshLayoutId);
        this.mSwipeRefreshLayout.setOnRefreshListener(() -> {
            if (this.mRefreshBaseReclycer != null) {
                this.mSwipeRefreshLayout.setRefreshing(true);
                this.mRefreshBaseReclycer.onRefreshItems();
            }
        });
    }

    public void disableSwipeRefresh() {
        this.mSwipeRefreshLayout.setEnabled(false);
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public BaseSimpleRecyclerView(AppCompatActivity appCompatActivity, int recyclerViewId) {
        this.parentView = appCompatActivity.findViewById(0x1020002).getRootView();
        this.recyclerView = (RecyclerView)this.parentView.findViewById(recyclerViewId);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.parentView.getContext()));
    }

    public BaseSimpleRecyclerView(AppCompatActivity appCompatActivity, int recyclerViewId, int swipeRefreshLayoutId) {
        this.parentView = appCompatActivity.findViewById(0x1020002).getRootView();
        this.recyclerView = (RecyclerView)this.parentView.findViewById(recyclerViewId);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.parentView.getContext()));
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)this.parentView.findViewById(swipeRefreshLayoutId);
        this.mSwipeRefreshLayout.setOnRefreshListener(() -> {
            if (this.mRefreshBaseReclycer != null) {
                this.mSwipeRefreshLayout.setRefreshing(true);
                this.mRefreshBaseReclycer.onRefreshItems();
            }
        });
    }

    public BaseSimpleRecyclerView(View view, int recyclerViewId) {
        this.recyclerView = (RecyclerView)view.findViewById(recyclerViewId);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
    }

    public BaseSimpleRecyclerView addBottomOffsetDecoration(int height) {
        BottomOffsetDecoration bottomOffsetDecoration = new BottomOffsetDecoration(height);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)bottomOffsetDecoration);
        return this;
    }

    public BaseSimpleRecyclerView setRefreshBaseRecycler(RefreshBaseRecyclerCallback refreshBaseRecycler) {
        this.mRefreshBaseReclycer = refreshBaseRecycler;
        return this;
    }

    public BaseSimpleRecyclerView setAdapter(BaseSimpleAdapter adapter) {
        this.adapter = adapter;
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        return this;
    }

    public BaseSimpleRecyclerView setLayout(LinearLayoutManager layout2) {
        this.layout = layout2;
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layout2);
        return this;
    }

    public BaseSimpleRecyclerView setGridManager() {
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.parentView.getContext(), 3));
        return this;
    }

    public BaseSimpleRecyclerView setEmptyView(int emptyViewId) {
        this.emptyView = (ViewGroup)this.parentView.findViewById(emptyViewId);
        return this;
    }

    public void update(List list) {
        this.adapter.update(list);
        if (this.emptyView != null) {
            if (list.size() > 0) {
                this.emptyView.setVisibility(8);
            } else {
                this.emptyView.setVisibility(0);
            }
        }
    }

    public void stopRefresh() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public static class BottomOffsetDecoration
    extends RecyclerView.ItemDecoration {
        private int mBottomOffset;

        public BottomOffsetDecoration(int bottomOffset) {
            this.mBottomOffset = bottomOffset;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            super.getItemOffsets(outRect, view, parent, state);
            int dataSize = state.getItemCount();
            int position = parent.getChildAdapterPosition(view);
            if (dataSize > 0 && position == dataSize - 1) {
                outRect.set(0, 0, 0, this.mBottomOffset);
            } else {
                outRect.set(0, 0, 0, 0);
            }
        }
    }
}

