/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;
import com.example.resources.R;

public class MessageUtils {
    private static ProgressDialog sProgressDialog;
    private static Toast mToast;

    public static void createDialog(Activity context, String title, String message, Callback callback) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)context);
        LayoutInflater inflater = context.getLayoutInflater();
        View dialogView = inflater.inflate(R.layout.custom_dialog, null);
        dialogBuilder.setView(dialogView);
        EditText edt = (EditText)dialogView.findViewById(R.id.cuastom_quantity_edittext);
        dialogBuilder.setTitle((CharSequence)title);
        dialogBuilder.setMessage((CharSequence)message);
        dialogBuilder.setPositiveButton((CharSequence)"Aceptar", (dialog, whichButton) -> {
            callback.onStringResult(edt.getText().toString());
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.hideSoftInputFromWindow(edt.getWindowToken(), 0);
            dialog.dismiss();
        });
        dialogBuilder.setNegativeButton((CharSequence)"Cancelar", (dialog, whichButton) -> {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.hideSoftInputFromWindow(edt.getWindowToken(), 0);
            dialog.dismiss();
        });
        AlertDialog b = dialogBuilder.create();
        b.show();
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(2, 0);
        }
    }

    public static void toast(Context context, int message) {
        if (context == null) {
            return;
        }
        if (mToast != null) {
            mToast.cancel();
        }
        mToast = Toast.makeText((Context)context, (int)message, (int)1);
        mToast.show();
    }

    public static void toast(Context context, String message) {
        if (context == null) {
            return;
        }
        if (mToast != null) {
            mToast.cancel();
        }
        mToast = Toast.makeText((Context)context, (CharSequence)message, (int)1);
        mToast.show();
    }

    public static void progress(Activity activity, int message) {
        MessageUtils.stopProgress();
        if (!activity.isFinishing()) {
            sProgressDialog = ProgressDialog.show((Context)activity, null, (CharSequence)activity.getString(message), (boolean)true, (boolean)false);
            sProgressDialog.show();
        }
    }

    public static void progress(Activity activity, String message) {
        MessageUtils.stopProgress();
        if (!activity.isFinishing()) {
            sProgressDialog = ProgressDialog.show((Context)activity, null, (CharSequence)message, (boolean)true, (boolean)false);
            sProgressDialog.show();
        }
    }

    public static void stopProgress() {
        try {
            if (sProgressDialog != null) {
                sProgressDialog.cancel();
                sProgressDialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback {
        public void onStringResult(String var1);
    }
}

