/*
 * Decompiled with CFR 0.152.
 */
package com.resources.icc.viewflow.core;

import android.view.View;
import com.resources.icc.viewflow.core.LinkagePager;
import com.resources.icc.viewflow.core.Utils;

public class LinkageCoverTransformer
implements LinkagePager.PageTransformer {
    public static final String TAG = "CoverTransformer";
    public static final float SCALE_MIN = 0.3f;
    public static final float SCALE_MAX = 1.0f;
    public static final float MARGIN_MIN = 0.0f;
    public static final float MARGIN_MAX = 50.0f;
    public float scale = 0.0f;
    public float pagerMargin = 0.0f;
    public float spaceValue = 0.0f;
    private float rotationY = 0.0f;

    public LinkageCoverTransformer(float scale, float pagerMargin, float spaceValue, float rotationY) {
        this.scale = scale;
        this.pagerMargin = pagerMargin;
        this.spaceValue = spaceValue;
        this.rotationY = rotationY;
    }

    @Override
    public void transformPage(View page, float position) {
        if (this.scale != 0.0f) {
            float realScale = Utils.getFloat(1.0f - Math.abs(position * this.scale), 0.3f, 1.0f);
            page.setScaleX(realScale);
            page.setScaleY(realScale);
        }
        if (this.pagerMargin != 0.0f) {
            float realPagerMargin = position * this.pagerMargin;
            if (this.spaceValue != 0.0f) {
                float realSpaceValue = Utils.getFloat(Math.abs(position * this.spaceValue), 0.0f, 50.0f);
                realPagerMargin += position > 0.0f ? realSpaceValue : -realSpaceValue;
            }
            page.setTranslationX(realPagerMargin);
        }
        if (this.rotationY != 0.0f) {
            float realRotationY = Math.abs(position * this.rotationY);
            page.setRotationY(position < 0.0f ? realRotationY : -realRotationY);
        }
    }
}

