/*
 * Decompiled with CFR 0.152.
 */
package com.resources.background;

import android.content.Context;
import com.google.gson.Gson;
import com.orhanobut.logger.Logger;
import com.resources.background.BaseDefinition;
import com.resources.background.WSBaseRequestInterface;
import com.resources.background.WSBaseResponseInterface;
import com.resources.background.WSCallback;
import com.resources.utils.ConnectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class BaseWSManager<D extends BaseDefinition> {
    private Context mContext;
    private WSCallback mWSCallback;
    private Call<ResponseBody> mBaseResponseCall;
    private static final List<String> errorRegisters = new ArrayList<String>();

    public BaseWSManager settings(Context context) {
        this.mContext = context;
        return this;
    }

    public BaseWSManager settings(WSCallback WSCallback2) {
        this.mContext = (Context)WSCallback2;
        this.mWSCallback = WSCallback2;
        return this;
    }

    public BaseWSManager settings(Context context, WSCallback WSCallback2) {
        this.mContext = context;
        this.mWSCallback = WSCallback2;
        return this;
    }

    protected abstract D getDefinition();

    abstract Call<ResponseBody> getWebService(String var1, WSBaseRequestInterface var2);

    abstract Call<ResponseBody> getQueryWebService(String var1, String var2);

    protected abstract String getJsonDebug(String var1);

    protected abstract boolean getErrorDebugEnabled();

    protected abstract boolean getDebugEnabled();

    public <R extends WSBaseResponseInterface> R requestWsSync(Class<R> tClass, String webServiceKey, WSBaseRequestInterface wsBaseRequest) {
        if (this.getDebugEnabled()) {
            Gson gson = new Gson();
            Logger.d((Object)gson.toJson((Object)wsBaseRequest));
            return (R)((WSBaseResponseInterface)gson.fromJson(this.getJsonDebug(webServiceKey), tClass));
        }
        try {
            this.mBaseResponseCall = this.getWebService(webServiceKey, wsBaseRequest);
            Response bodyResponse = this.mBaseResponseCall.execute();
            if (bodyResponse.isSuccessful()) {
                String json = ((ResponseBody)bodyResponse.body()).string();
                Gson gson = new Gson();
                return (R)((WSBaseResponseInterface)gson.fromJson(json, tClass));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <R extends WSBaseResponseInterface> BaseWSManager requestWs(final Class<R> tClass, final String webServiceKey, WSBaseRequestInterface wsBaseRequest) {
        if (this.getDebugEnabled()) {
            Gson gson = new Gson();
            WSBaseResponseInterface response = (WSBaseResponseInterface)gson.fromJson(this.getJsonDebug(webServiceKey), tClass);
            Logger.d((Object)gson.toJson((Object)wsBaseRequest));
            this.mWSCallback.onSuccessLoadResponse(webServiceKey, response);
            return this;
        }
        if (ConnectionUtils.isConnected(this.mContext)) {
            this.mWSCallback.onRequestWS(webServiceKey);
            this.mBaseResponseCall = this.getWebService(webServiceKey, wsBaseRequest);
            this.mBaseResponseCall.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    if (response.isSuccessful()) {
                        try {
                            String json = ((ResponseBody)response.body()).string();
                            Gson gson = new Gson();
                            BaseWSManager.this.mWSCallback.onSuccessLoadResponse(webServiceKey, (WSBaseResponseInterface)gson.fromJson(json, tClass));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "");
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                    if (!call.isCanceled()) {
                        BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "");
                    }
                }
            });
        } else {
            this.mWSCallback.onErrorConnection();
        }
        return this;
    }

    public <R extends WSBaseResponseInterface> BaseWSManager requestWs(final Class<R> tClass, final String webServiceKey, String requestValue) {
        if (ConnectionUtils.isConnected(this.mContext)) {
            this.mWSCallback.onRequestWS(webServiceKey);
            this.mBaseResponseCall = this.getQueryWebService(webServiceKey, requestValue);
            this.mBaseResponseCall.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    block5: {
                        if (response.isSuccessful()) {
                            try {
                                String json = ((ResponseBody)response.body()).string();
                                if (BaseWSManager.this.isJSONValid(json)) {
                                    Gson gson = new Gson();
                                    BaseWSManager.this.mWSCallback.onSuccessLoadResponse(webServiceKey, (WSBaseResponseInterface)gson.fromJson(json, tClass));
                                    break block5;
                                }
                                BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "Ha ocurrido un error al procesar la informacion. Intente nuevamente.");
                            }
                            catch (IOException e) {
                                BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "Ha ocurrido un error al procesar la informacion. Intente nuevamente.");
                                e.printStackTrace();
                            }
                        } else {
                            BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "Ha ocurrido un error al procesar la informacion. Intente nuevamente.");
                        }
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                    BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "Ha ocurrido un error al procesar la informacion. Intente nuevamente.");
                }
            });
        } else {
            this.mWSCallback.onErrorConnection();
        }
        return this;
    }

    public boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public void onDestroy() {
        if (this.mBaseResponseCall != null && this.mBaseResponseCall.isExecuted()) {
            this.mBaseResponseCall.cancel();
        }
    }
}

