/*
 * Decompiled with CFR 0.152.
 */
package de.derklaro.projects.deer.api.basic;

import de.derklaro.projects.deer.api.Database;
import de.derklaro.projects.deer.api.filter.Filter;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class Filters {
    private Filters() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Filter keyEq(final @NotNull String keyToFind) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> target) {
                String primaryKey = keyFile.split("-")[0];
                return primaryKey.equals(keyToFind);
            }
        };
    }

    @NotNull
    public static Filter anyMatch(final @NotNull String toFind) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> target) {
                String[] all = keyFile.split("-");
                return Arrays.asList(all).contains(toFind);
            }
        };
    }

    @NotNull
    public static Filter anyValueMatch(final @NotNull String valueToFind) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> target) {
                String[] all = keyFile.split("-");
                if (all.length == 1) {
                    return false;
                }
                all = Arrays.copyOfRange(all, 1, all.length);
                return Arrays.asList(all).contains(valueToFind);
            }
        };
    }

    @NotNull
    public static Filter findValue(final @NotNull String valueToFind, final int valueIndex) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> target) {
                String[] all = keyFile.split("-");
                if (all.length <= valueIndex) {
                    return false;
                }
                return all[valueIndex].equals(valueToFind);
            }
        };
    }

    @NotNull
    public static Filter keyLt(final long longToFind) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> database) {
                return Filters.toLong(keyFile.split("-")[0], e -> e < longToFind);
            }
        };
    }

    @NotNull
    public static Filter keyHt(final long longToFind) {
        return new Filter(){

            @Override
            public boolean filter(@NotNull String keyFile, @NotNull Database<?> database) {
                return Filters.toLong(keyFile.split("-")[0], e -> e > longToFind);
            }
        };
    }

    private static boolean toLong(String parse, Predicate<Long> predicate) {
        try {
            long l = Long.parseLong(parse);
            return predicate.test(l);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

