/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping;

import java.util.Comparator;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentEntity;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentProperty;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;

public class DynamoDBPersistentEntityImpl<T>
extends BasicPersistentEntity<T, DynamoDBPersistentProperty>
implements DynamoDBPersistentEntity<T> {
    public DynamoDBPersistentEntityImpl(TypeInformation<T> information, Comparator<DynamoDBPersistentProperty> comparator) {
        super(information, comparator);
    }

    protected DynamoDBPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(DynamoDBPersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        DynamoDBPersistentProperty idProperty = (DynamoDBPersistentProperty)this.getIdProperty();
        if (idProperty != null) {
            if (idProperty.isCompositeIdProperty() && property.isHashKeyProperty()) {
                return null;
            }
            if (idProperty.isHashKeyProperty() && property.isCompositeIdProperty()) {
                return property;
            }
            throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), idProperty.getField()));
        }
        return property;
    }
}

