/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyMethodExtractor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DynamoDBHashAndRangeKeyMethodExtractorImpl<T>
implements DynamoDBHashAndRangeKeyMethodExtractor<T> {
    private final Class<T> idType;
    private Method hashKeyMethod;
    private Method rangeKeyMethod;
    private Field hashKeyField;
    private Field rangeKeyField;

    public DynamoDBHashAndRangeKeyMethodExtractorImpl(final Class<T> idType) {
        Assert.notNull(idType, (String)"Id type must not be null!");
        this.idType = idType;
        ReflectionUtils.doWithMethods(idType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.getAnnotation(DynamoDBHashKey.class) != null) {
                    Assert.isNull((Object)DynamoDBHashAndRangeKeyMethodExtractorImpl.this.hashKeyMethod, (String)("Multiple methods annotated by @DynamoDBHashKey within type " + idType.getName() + "!"));
                    ReflectionUtils.makeAccessible((Method)method);
                    DynamoDBHashAndRangeKeyMethodExtractorImpl.this.hashKeyMethod = method;
                }
            }
        });
        ReflectionUtils.doWithFields(idType, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(DynamoDBHashKey.class) != null) {
                    Assert.isNull((Object)DynamoDBHashAndRangeKeyMethodExtractorImpl.this.hashKeyField, (String)("Multiple fields annotated by @DynamoDBHashKey within type " + idType.getName() + "!"));
                    ReflectionUtils.makeAccessible((Field)field);
                    DynamoDBHashAndRangeKeyMethodExtractorImpl.this.hashKeyField = field;
                }
            }
        });
        ReflectionUtils.doWithMethods(idType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.getAnnotation(DynamoDBRangeKey.class) != null) {
                    Assert.isNull((Object)DynamoDBHashAndRangeKeyMethodExtractorImpl.this.rangeKeyMethod, (String)("Multiple methods annotated by @DynamoDBRangeKey within type " + idType.getName() + "!"));
                    ReflectionUtils.makeAccessible((Method)method);
                    DynamoDBHashAndRangeKeyMethodExtractorImpl.this.rangeKeyMethod = method;
                }
            }
        });
        ReflectionUtils.doWithFields(idType, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getAnnotation(DynamoDBRangeKey.class) != null) {
                    Assert.isNull((Object)DynamoDBHashAndRangeKeyMethodExtractorImpl.this.rangeKeyField, (String)("Multiple fields annotated by @DynamoDBRangeKey within type " + idType.getName() + "!"));
                    ReflectionUtils.makeAccessible((Field)field);
                    DynamoDBHashAndRangeKeyMethodExtractorImpl.this.rangeKeyField = field;
                }
            }
        });
        if (this.hashKeyMethod == null && this.hashKeyField == null) {
            throw new IllegalArgumentException("No method or field annotated by @DynamoDBHashKey within type " + idType.getName() + "!");
        }
        if (this.rangeKeyMethod == null && this.rangeKeyField == null) {
            throw new IllegalArgumentException("No method or field annotated by @DynamoDBRangeKey within type " + idType.getName() + "!");
        }
        if (this.hashKeyMethod != null && this.hashKeyField != null) {
            throw new IllegalArgumentException("Both method and field annotated by @DynamoDBHashKey within type " + idType.getName() + "!");
        }
        if (this.rangeKeyMethod != null && this.rangeKeyField != null) {
            throw new IllegalArgumentException("Both method and field annotated by @DynamoDBRangeKey within type " + idType.getName() + "!");
        }
    }

    public Class<T> getJavaType() {
        return this.idType;
    }

    @Override
    public Method getHashKeyMethod() {
        return this.hashKeyMethod;
    }

    @Override
    public Method getRangeKeyMethod() {
        return this.rangeKeyMethod;
    }

    @Override
    public Field getHashKeyField() {
        return this.hashKeyField;
    }

    @Override
    public Field getRangeKeyField() {
        return this.rangeKeyField;
    }
}

