/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentEntityImpl;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

class DynamoDBPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<DynamoDBPersistentProperty>
implements DynamoDBPersistentProperty {
    private static final Collection<Class<? extends Annotation>> ASSOCIATION_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> ID_ANNOTATIONS;

    public DynamoDBPersistentPropertyImpl(Property property, DynamoDBPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    public boolean isWritable() {
        return !this.isAnnotationPresent(DynamoDBIgnore.class);
    }

    @Override
    public boolean isHashKeyProperty() {
        return this.isAnnotationPresent(DynamoDBHashKey.class);
    }

    @Override
    public boolean isCompositeIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    public boolean isIdProperty() {
        for (Class<? extends Annotation> annotation : ID_ANNOTATIONS) {
            if (!this.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntity() {
        return this.isAnnotationPresent(Reference.class);
    }

    public boolean isAssociation() {
        for (Class<? extends Annotation> annotationType : ASSOCIATION_ANNOTATIONS) {
            if (this.findAnnotation(annotationType) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isTransient() {
        return this.isAnnotationPresent(Transient.class) || super.isTransient() || this.isAnnotationPresent(DynamoDBIgnore.class);
    }

    public boolean isVersionProperty() {
        return super.isVersionProperty() || this.isAnnotationPresent(DynamoDBVersionAttribute.class);
    }

    protected Association<DynamoDBPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    static {
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
        annotations.add(Reference.class);
        ASSOCIATION_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Id.class);
        annotations.add(DynamoDBHashKey.class);
        ID_ANNOTATIONS = annotations;
    }
}

