/*
 * Decompiled with CFR 0.152.
 */
package com.denzcoskun.imageslider.transformation;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import com.denzcoskun.imageslider.transformation.RoundedTransformation$WhenMappings;
import com.squareup.picasso.Transformation;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J(\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/denzcoskun/imageslider/transformation/RoundedTransformation;", "Lcom/squareup/picasso/Transformation;", "radius", "", "margin", "cornerType", "Lcom/denzcoskun/imageslider/transformation/RoundedTransformation$CornerType;", "(IILcom/denzcoskun/imageslider/transformation/RoundedTransformation$CornerType;)V", "mCornerType", "mDiameter", "", "mMargin", "mRadius", "drawBottomLeftRoundRect", "", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "right", "bottom", "drawBottomRightRoundRect", "drawBottomRoundRect", "drawDiagonalFromTopLeftRoundRect", "drawDiagonalFromTopRightRoundRect", "drawLeftRoundRect", "drawOtherBottomLeftRoundRect", "drawOtherBottomRightRoundRect", "drawOtherTopLeftRoundRect", "drawOtherTopRightRoundRect", "drawRightRoundRect", "drawRoundRect", "width", "height", "drawTopLeftRoundRect", "drawTopRightRoundRect", "drawTopRoundRect", "key", "", "transform", "Landroid/graphics/Bitmap;", "source", "CornerType", "imageslider_release"})
public final class RoundedTransformation
implements Transformation {
    private float mRadius;
    private float mDiameter;
    private float mMargin;
    private CornerType mCornerType;

    @NotNull
    public Bitmap transform(@NotNull Bitmap source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        this.drawRoundRect(canvas, paint, width, height);
        source.recycle();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private final void drawRoundRect(Canvas canvas, Paint paint, float width, float height) {
        float right = width - this.mMargin;
        float bottom = height - this.mMargin;
        switch (RoundedTransformation$WhenMappings.$EnumSwitchMapping$0[this.mCornerType.ordinal()]) {
            case 1: {
                canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, right, bottom), this.mRadius, this.mRadius, paint);
                break;
            }
            case 2: {
                this.drawTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 3: {
                this.drawTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 4: {
                this.drawBottomLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 5: {
                this.drawBottomRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 6: {
                this.drawTopRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 7: {
                this.drawBottomRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 8: {
                this.drawLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 9: {
                this.drawRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 10: {
                this.drawOtherTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 11: {
                this.drawOtherTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 12: {
                this.drawOtherBottomLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 13: {
                this.drawOtherBottomRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 14: {
                this.drawDiagonalFromTopLeftRoundRect(canvas, paint, right, bottom);
                break;
            }
            case 15: {
                this.drawDiagonalFromTopRightRoundRect(canvas, paint, right, bottom);
                break;
            }
            default: {
                canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, right, bottom), this.mRadius, this.mRadius, paint);
            }
        }
    }

    private final void drawTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin + this.mRadius, this.mMargin + this.mRadius, bottom), paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin, right, bottom), paint);
    }

    private final void drawTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - this.mDiameter, this.mMargin, right, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right - this.mRadius, bottom), paint);
        canvas.drawRect(new RectF(right - this.mRadius, this.mMargin + this.mRadius, right, bottom), paint);
    }

    private final void drawBottomLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, bottom - this.mDiameter, this.mMargin + this.mDiameter, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, bottom - this.mRadius), paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin, right, bottom), paint);
    }

    private final void drawBottomRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - this.mDiameter, bottom - this.mDiameter, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right - this.mRadius, bottom), paint);
        canvas.drawRect(new RectF(right - this.mRadius, this.mMargin, right, bottom - this.mRadius), paint);
    }

    private final void drawTopRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, right, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin + this.mRadius, right, bottom), paint);
    }

    private final void drawBottomRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, bottom - this.mDiameter, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right, bottom - this.mRadius), paint);
    }

    private final void drawLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin, right, bottom), paint);
    }

    private final void drawRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - this.mDiameter, this.mMargin, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right - this.mRadius, bottom), paint);
    }

    private final void drawOtherTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, bottom - this.mDiameter, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - this.mDiameter, this.mMargin, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right - this.mRadius, bottom - this.mRadius), paint);
    }

    private final void drawOtherTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(this.mMargin, bottom - this.mDiameter, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin, right, bottom - this.mRadius), paint);
    }

    private final void drawOtherBottomLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, right, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - this.mDiameter, this.mMargin, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin + this.mRadius, right - this.mRadius, bottom), paint);
    }

    private final void drawOtherBottomRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, right, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin + this.mRadius, right, bottom), paint);
    }

    private final void drawDiagonalFromTopLeftRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(this.mMargin, this.mMargin, this.mMargin + this.mDiameter, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(right - this.mDiameter, bottom - this.mDiameter, right, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin + this.mRadius, right - this.mDiameter, bottom), paint);
        canvas.drawRect(new RectF(this.mMargin + this.mDiameter, this.mMargin, right, bottom - this.mRadius), paint);
    }

    private final void drawDiagonalFromTopRightRoundRect(Canvas canvas, Paint paint, float right, float bottom) {
        canvas.drawRoundRect(new RectF(right - this.mDiameter, this.mMargin, right, this.mMargin + this.mDiameter), this.mRadius, this.mRadius, paint);
        canvas.drawRoundRect(new RectF(this.mMargin, bottom - this.mDiameter, this.mMargin + this.mDiameter, bottom), this.mRadius, this.mRadius, paint);
        canvas.drawRect(new RectF(this.mMargin, this.mMargin, right - this.mRadius, bottom - this.mRadius), paint);
        canvas.drawRect(new RectF(this.mMargin + this.mRadius, this.mMargin + this.mRadius, right, bottom), paint);
    }

    @NotNull
    public String key() {
        return "RoundedTransformation(radius=" + this.mRadius + ", margin=" + this.mMargin + ", diameter=" + this.mDiameter + ", cornerType=" + this.mCornerType.name() + ")";
    }

    @JvmOverloads
    public RoundedTransformation(int radius, int margin, @NotNull CornerType cornerType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cornerType), (String)"cornerType");
        this.mRadius = radius;
        this.mDiameter = radius * 2;
        this.mMargin = margin;
        this.mCornerType = cornerType;
    }

    @JvmOverloads
    public /* synthetic */ RoundedTransformation(int n, int n2, CornerType cornerType, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            cornerType = CornerType.ALL;
        }
        this(n, n2, cornerType);
    }

    @JvmOverloads
    public RoundedTransformation(int radius, int margin) {
        this(radius, margin, null, 4, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0011\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/denzcoskun/imageslider/transformation/RoundedTransformation$CornerType;", "", "(Ljava/lang/String;I)V", "ALL", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT", "TOP", "BOTTOM", "LEFT", "RIGHT", "OTHER_TOP_LEFT", "OTHER_TOP_RIGHT", "OTHER_BOTTOM_LEFT", "OTHER_BOTTOM_RIGHT", "DIAGONAL_FROM_TOP_LEFT", "DIAGONAL_FROM_TOP_RIGHT", "imageslider_release"})
    public static final class CornerType
    extends Enum<CornerType> {
        public static final /* enum */ CornerType ALL;
        public static final /* enum */ CornerType TOP_LEFT;
        public static final /* enum */ CornerType TOP_RIGHT;
        public static final /* enum */ CornerType BOTTOM_LEFT;
        public static final /* enum */ CornerType BOTTOM_RIGHT;
        public static final /* enum */ CornerType TOP;
        public static final /* enum */ CornerType BOTTOM;
        public static final /* enum */ CornerType LEFT;
        public static final /* enum */ CornerType RIGHT;
        public static final /* enum */ CornerType OTHER_TOP_LEFT;
        public static final /* enum */ CornerType OTHER_TOP_RIGHT;
        public static final /* enum */ CornerType OTHER_BOTTOM_LEFT;
        public static final /* enum */ CornerType OTHER_BOTTOM_RIGHT;
        public static final /* enum */ CornerType DIAGONAL_FROM_TOP_LEFT;
        public static final /* enum */ CornerType DIAGONAL_FROM_TOP_RIGHT;
        private static final /* synthetic */ CornerType[] $VALUES;

        static {
            CornerType[] cornerTypeArray = new CornerType[15];
            CornerType[] cornerTypeArray2 = cornerTypeArray;
            cornerTypeArray[0] = ALL = new CornerType();
            cornerTypeArray[1] = TOP_LEFT = new CornerType();
            cornerTypeArray[2] = TOP_RIGHT = new CornerType();
            cornerTypeArray[3] = BOTTOM_LEFT = new CornerType();
            cornerTypeArray[4] = BOTTOM_RIGHT = new CornerType();
            cornerTypeArray[5] = TOP = new CornerType();
            cornerTypeArray[6] = BOTTOM = new CornerType();
            cornerTypeArray[7] = LEFT = new CornerType();
            cornerTypeArray[8] = RIGHT = new CornerType();
            cornerTypeArray[9] = OTHER_TOP_LEFT = new CornerType();
            cornerTypeArray[10] = OTHER_TOP_RIGHT = new CornerType();
            cornerTypeArray[11] = OTHER_BOTTOM_LEFT = new CornerType();
            cornerTypeArray[12] = OTHER_BOTTOM_RIGHT = new CornerType();
            cornerTypeArray[13] = DIAGONAL_FROM_TOP_LEFT = new CornerType();
            cornerTypeArray[14] = DIAGONAL_FROM_TOP_RIGHT = new CornerType();
            $VALUES = cornerTypeArray;
        }

        public static CornerType[] values() {
            return (CornerType[])$VALUES.clone();
        }

        public static CornerType valueOf(String string) {
            return Enum.valueOf(CornerType.class, string);
        }
    }
}

