/*
 * Decompiled with CFR 0.152.
 */
package com.denzcoskun.imageslider.adapters;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.denzcoskun.imageslider.R;
import com.denzcoskun.imageslider.interfaces.ItemClickListener;
import com.denzcoskun.imageslider.models.SlideModel;
import com.denzcoskun.imageslider.transformation.RoundedTransformation;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/denzcoskun/imageslider/adapters/ViewPagerAdapter;", "Landroid/support/v4/view/PagerAdapter;", "context", "Landroid/content/Context;", "imageList", "", "Lcom/denzcoskun/imageslider/models/SlideModel;", "radius", "", "errorImage", "placeholder", "(Landroid/content/Context;Ljava/util/List;III)V", "itemClickListener", "Lcom/denzcoskun/imageslider/interfaces/ItemClickListener;", "layoutInflater", "Landroid/view/LayoutInflater;", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "object", "", "getCount", "instantiateItem", "Landroid/view/View;", "isViewFromObject", "", "view", "obj", "setItemClickListener", "imageslider_release"})
public final class ViewPagerAdapter
extends PagerAdapter {
    private List<SlideModel> imageList;
    private LayoutInflater layoutInflater;
    private ItemClickListener itemClickListener;
    private int radius;
    private int errorImage;
    private int placeholder;

    public boolean isViewFromObject(@NotNull View view, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return Intrinsics.areEqual((Object)view, (Object)obj);
    }

    public int getCount() {
        List<SlideModel> list = this.imageList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size();
    }

    @NotNull
    public View instantiateItem(@NotNull ViewGroup container, int position) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        LayoutInflater layoutInflater = this.layoutInflater;
        if (layoutInflater == null) {
            Intrinsics.throwNpe();
        }
        View itemView = layoutInflater.inflate(R.layout.pager_row, container, false);
        ImageView imageView = (ImageView)itemView.findViewById(R.id.image_view);
        LinearLayout linearLayout = (LinearLayout)itemView.findViewById(R.id.linear_layout);
        TextView textView = (TextView)itemView.findViewById(R.id.text_view);
        List<SlideModel> list = this.imageList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (list.get(position).getTitle() != null) {
            TextView textView2 = textView;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"textView");
            List<SlideModel> list2 = this.imageList;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            textView2.setText((CharSequence)list2.get(position).getTitle());
        } else {
            LinearLayout linearLayout2 = linearLayout;
            Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout2, (String)"linearLayout");
            linearLayout2.setVisibility(4);
        }
        List<SlideModel> list3 = this.imageList;
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        if (list3.get(position).getImageUrl() == null) {
            Picasso picasso = Picasso.get();
            List<SlideModel> list4 = this.imageList;
            if (list4 == null) {
                Intrinsics.throwNpe();
            }
            Integer n = list4.get(position).getImagePath();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            picasso.load(n.intValue()).fit().transform((Transformation)new RoundedTransformation(this.radius, 0, null, 4, null)).placeholder(this.placeholder).error(this.errorImage).into(imageView);
        } else {
            Picasso picasso = Picasso.get();
            List<SlideModel> list5 = this.imageList;
            if (list5 == null) {
                Intrinsics.throwNpe();
            }
            String string = list5.get(position).getImageUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            picasso.load(string).fit().transform((Transformation)new RoundedTransformation(this.radius, 0, null, 4, null)).placeholder(this.placeholder).error(this.errorImage).into(imageView);
        }
        container.addView(itemView);
        imageView.setOnClickListener(new View.OnClickListener(this, position){
            final /* synthetic */ ViewPagerAdapter this$0;
            final /* synthetic */ int $position;

            public final void onClick(View it) {
                block0: {
                    ItemClickListener itemClickListener = ViewPagerAdapter.access$getItemClickListener$p(this.this$0);
                    if (itemClickListener == null) break block0;
                    itemClickListener.onItemSelected(this.$position);
                }
            }
            {
                this.this$0 = viewPagerAdapter;
                this.$position = n;
            }
        });
        View view = itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return view;
    }

    public final void setItemClickListener(@NotNull ItemClickListener itemClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)itemClickListener, (String)"itemClickListener");
        this.itemClickListener = itemClickListener;
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        container.removeView((View)((RelativeLayout)object));
    }

    public ViewPagerAdapter(@Nullable Context context, @NotNull List<SlideModel> imageList, int radius, int errorImage, int placeholder) {
        Intrinsics.checkParameterIsNotNull(imageList, (String)"imageList");
        this.radius = radius;
        this.errorImage = errorImage;
        this.placeholder = placeholder;
        this.imageList = imageList;
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        this.layoutInflater = (LayoutInflater)context2.getSystemService("layout_inflater");
    }

    @Nullable
    public static final /* synthetic */ ItemClickListener access$getItemClickListener$p(ViewPagerAdapter $this) {
        return $this.itemClickListener;
    }

    public static final /* synthetic */ void access$setItemClickListener$p(ViewPagerAdapter $this, @Nullable ItemClickListener itemClickListener) {
        $this.itemClickListener = itemClickListener;
    }
}

