/*
 * Decompiled with CFR 0.152.
 */
package com.xandryex.utils;

import com.xandryex.utils.OnWordFoundCallback;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

abstract class WordFinder
implements OnWordFoundCallback {
    private static int DEFAULT_POS = 0;
    private static int DEFAULT_LAST_USED_RUN = -1;
    private String bookmark;

    WordFinder() {
    }

    void findWordsInTable(XWPFDocument doc, String word) {
        this.bookmark = word;
        for (XWPFTable t : doc.getTables()) {
            this.checkTable(t);
        }
    }

    void findWordsInText(XWPFDocument doc, String word) {
        this.bookmark = word;
        for (XWPFParagraph p : doc.getParagraphs()) {
            if (!this.paragraphNotNullAndHasRuns(p)) continue;
            this.checkInParagraph(p);
        }
    }

    private void checkTable(XWPFTable t) {
        if (t.getRows() == null) {
            return;
        }
        for (XWPFTableRow r : t.getRows()) {
            this.checkRow(r);
        }
    }

    private void checkRow(XWPFTableRow r) {
        if (r.getTableCells() == null) {
            return;
        }
        for (XWPFTableCell cell : r.getTableCells()) {
            this.checkCell(cell);
        }
    }

    private void checkCell(XWPFTableCell cell) {
        if (cell.getParagraphs() == null) {
            return;
        }
        for (XWPFParagraph p : cell.getParagraphs()) {
            if (!this.paragraphNotNullAndHasRuns(p)) continue;
            this.checkInParagraph(p);
        }
    }

    private void checkInParagraph(XWPFParagraph p) {
        List runs = p.getRuns();
        int lastUsedRun = DEFAULT_LAST_USED_RUN;
        for (int runIndex = 0; runIndex < runs.size(); ++runIndex) {
            XWPFRun run = (XWPFRun)p.getRuns().get(runIndex);
            if (!this.isRunNotNullAndNotEmpty(run)) continue;
            String text = run.getText(DEFAULT_POS);
            if (text.contains(this.bookmark)) {
                this.onWordFoundInRun(run);
                lastUsedRun = runIndex;
                continue;
            }
            if (!this.nextRunHasText(runs, runIndex) || this.nextRunsText(runs, runIndex).contains(this.bookmark) || !this.isWordInPreviousCurrentNextRuns(runs, lastUsedRun, runIndex)) continue;
            this.onWordFoundInPreviousCurrentNextRun(runs, runIndex);
        }
    }

    private boolean isWordInPreviousCurrentNextRuns(List<XWPFRun> runs, int lastUsedRun, int runIndex) {
        return this.isNotFirstRun(runIndex) && this.previousRunHasText(runs, runIndex) && this.previousRunWasNotUsed(lastUsedRun, runIndex) && this.lastThisNextRunText(runs, runIndex).contains(this.bookmark);
    }

    private boolean previousRunWasNotUsed(int lastUsedRun, int runIndex) {
        return lastUsedRun != runIndex - 1;
    }

    private boolean paragraphNotNullAndHasRuns(XWPFParagraph p) {
        return p != null && !p.getRuns().isEmpty();
    }

    private String lastThisNextRunText(List<XWPFRun> runs, int runIndex) {
        String text = runs.get(runIndex).getText(DEFAULT_POS);
        return this.lastAndCurrentRunsText(runs, runIndex, text) + this.nextRunsText(runs, runIndex);
    }

    private boolean nextRunHasText(List<XWPFRun> runs, int runIndex) {
        return runs.size() > runIndex + 1 && runs.get(runIndex + 1).getText(DEFAULT_POS) != null && !runs.get(runIndex + 1).getText(DEFAULT_POS).isEmpty();
    }

    private String nextRunsText(List<XWPFRun> runs, int i) {
        return runs.get(i + 1).getText(DEFAULT_POS);
    }

    private String lastAndCurrentRunsText(List<XWPFRun> runs, int runIndex, String text) {
        return runs.get(runIndex - 1).getText(DEFAULT_POS) + text;
    }

    private boolean previousRunHasText(List<XWPFRun> runs, int runIndex) {
        return runs.get(runIndex - 1).getText(DEFAULT_POS) != null && !runs.get(runIndex - 1).getText(DEFAULT_POS).isEmpty();
    }

    private boolean isNotFirstRun(int runIndex) {
        return runIndex > 0;
    }

    private boolean isRunNotNullAndNotEmpty(XWPFRun run) {
        return run != null && run.getText(DEFAULT_POS) != null;
    }
}

