/*
 * Decompiled with CFR 0.152.
 */
package com.xandryex.utils;

import com.xandryex.utils.WordFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextReplacer
extends WordFinder {
    private static int DEFAULT_TEXT_POS = 0;
    private String replacement;
    private String bookmark;

    public void replaceInText(XWPFDocument document, String bookmark, String replacement) {
        this.replacement = replacement;
        this.bookmark = bookmark;
        this.findWordsInText(document, bookmark);
    }

    public void replaceInTable(XWPFDocument document, String bookmark, String replacement) {
        this.replacement = replacement;
        this.bookmark = bookmark;
        this.findWordsInTable(document, bookmark);
    }

    @Override
    public void onWordFoundInRun(XWPFRun run) {
        this.replaceWordInRun(run);
    }

    @Override
    public void onWordFoundInPreviousCurrentNextRun(List<XWPFRun> runs, int currentRun) {
        this.replaceWordInPreviousCurrentNextRuns(runs, currentRun);
    }

    private void replaceWordInPreviousCurrentNextRuns(List<XWPFRun> runs, int currentRun) {
        boolean replacedInPreviousRun = this.replaceRunTextStart(runs.get(currentRun - 1));
        if (replacedInPreviousRun) {
            this.deleteTextFromRun(runs.get(currentRun));
        } else {
            this.replaceRunTextStart(runs.get(currentRun));
        }
        this.cleanRunTextStart(runs.get(currentRun + 1));
    }

    private void deleteTextFromRun(XWPFRun run) {
        run.setText("", DEFAULT_TEXT_POS);
    }

    private void replaceWordInRun(XWPFRun run) {
        String replacedText = run.getText(DEFAULT_TEXT_POS).replaceAll(Pattern.quote(this.bookmark), this.replacement);
        run.setText(replacedText, DEFAULT_TEXT_POS);
    }

    private boolean replaceRunTextStart(XWPFRun run) {
        String text = run.getText(DEFAULT_TEXT_POS);
        String remainingBookmark = this.getRemainingBookmarkStart(text, this.bookmark);
        if (!remainingBookmark.isEmpty()) {
            text = text.replace(remainingBookmark, this.replacement);
            run.setText(text, DEFAULT_TEXT_POS);
            return true;
        }
        return false;
    }

    private void cleanRunTextStart(XWPFRun run) {
        String text = run.getText(DEFAULT_TEXT_POS);
        String remainingBookmark = this.getRemainingBookmarkEnd(text, this.bookmark);
        text = text.replace(remainingBookmark, "");
        run.setText(text, DEFAULT_TEXT_POS);
    }

    private String getRemainingBookmarkEnd(String text, String bookmark) {
        if (!text.startsWith(bookmark)) {
            return this.getRemainingBookmarkEnd(text, bookmark.substring(1, bookmark.length()));
        }
        return bookmark;
    }

    private String getRemainingBookmarkStart(String text, String bookmark) {
        if (!text.endsWith(bookmark)) {
            return this.getRemainingBookmarkStart(text, bookmark.substring(0, bookmark.length() - 1));
        }
        return bookmark;
    }
}

