/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.poi;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.batch.item.excel.Sheet;

public class PoiSheet
implements Sheet {
    private final org.apache.poi.ss.usermodel.Sheet delegate;
    private final int numberOfRows;
    private final String name;
    private FormulaEvaluator evaluator;

    PoiSheet(org.apache.poi.ss.usermodel.Sheet delegate) {
        this.delegate = delegate;
        this.numberOfRows = this.delegate.getLastRowNum() + 1;
        this.name = this.delegate.getSheetName();
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRow(int rowNumber) {
        Row row = this.delegate.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        LinkedList<String> cells = new LinkedList<String>();
        int numberOfColumns = row.getLastCellNum();
        block7: for (int i = 0; i < numberOfColumns; ++i) {
            Cell cell = row.getCell(i);
            switch (cell.getCellType()) {
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        cells.add(String.valueOf(date.getTime()));
                        continue block7;
                    }
                    String doubleStr = new BigDecimal(cell.getNumericCellValue()).stripTrailingZeros().toPlainString();
                    cells.add(doubleStr);
                    continue block7;
                }
                case 4: {
                    cells.add(String.valueOf(cell.getBooleanCellValue()));
                    continue block7;
                }
                case 1: {
                    cells.add(cell.getStringCellValue());
                    continue block7;
                }
                case 3: {
                    cells.add(null);
                    continue block7;
                }
                case 2: {
                    cells.add(this.getFormulaEvaluator().evaluate(cell).formatAsString());
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Cannot handle cells of type " + cell.getCellType());
                }
            }
        }
        return cells.toArray(new String[cells.size()]);
    }

    private FormulaEvaluator getFormulaEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.delegate.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }
        return this.evaluator;
    }
}

