/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.Arrays;

public class ShowcaseTooltip {
    private View rootView;
    private View view;
    private TooltipView tooltip_view;

    private ShowcaseTooltip(Context context) {
        MyContext myContext = new MyContext(ShowcaseTooltip.getActivityContext(context));
        this.tooltip_view = new TooltipView(myContext.getContext());
    }

    public static ShowcaseTooltip build(Context context) {
        return new ShowcaseTooltip(context);
    }

    public void configureTarget(ViewGroup rootView, View view) {
        this.rootView = rootView;
        this.view = view;
    }

    private static Activity getActivityContext(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public ShowcaseTooltip position(Position position) {
        this.tooltip_view.setPosition(position);
        return this;
    }

    public ShowcaseTooltip customView(View customView) {
        this.tooltip_view.setCustomView(customView);
        return this;
    }

    public ShowcaseTooltip customView(int viewId) {
        this.tooltip_view.setCustomView(((Activity)this.view.getContext()).findViewById(viewId));
        return this;
    }

    public ShowcaseTooltip arrowWidth(int arrowWidth) {
        this.tooltip_view.setArrowWidth(arrowWidth);
        return this;
    }

    public ShowcaseTooltip arrowHeight(int arrowHeight) {
        this.tooltip_view.setArrowHeight(arrowHeight);
        return this;
    }

    public ShowcaseTooltip arrowSourceMargin(int arrowSourceMargin) {
        this.tooltip_view.setArrowSourceMargin(arrowSourceMargin);
        return this;
    }

    public ShowcaseTooltip arrowTargetMargin(int arrowTargetMargin) {
        this.tooltip_view.setArrowTargetMargin(arrowTargetMargin);
        return this;
    }

    public ShowcaseTooltip align(ALIGN align) {
        this.tooltip_view.setAlign(align);
        return this;
    }

    public TooltipView show(final int margin) {
        Context activityContext = this.tooltip_view.getContext();
        if (activityContext != null && activityContext instanceof Activity) {
            final ViewGroup decorView = this.rootView != null ? (ViewGroup)this.rootView : (ViewGroup)((Activity)activityContext).getWindow().getDecorView();
            this.view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    final Rect rect = new Rect();
                    ShowcaseTooltip.this.view.getGlobalVisibleRect(rect);
                    Rect rootGlobalRect = new Rect();
                    Point rootGlobalOffset = new Point();
                    decorView.getGlobalVisibleRect(rootGlobalRect, rootGlobalOffset);
                    int[] location = new int[2];
                    ShowcaseTooltip.this.view.getLocationOnScreen(location);
                    rect.left = location[0];
                    if (rootGlobalOffset != null) {
                        rect.top -= rootGlobalOffset.y;
                        rect.bottom -= rootGlobalOffset.y;
                        rect.left -= rootGlobalOffset.x;
                        rect.right -= rootGlobalOffset.x;
                    }
                    rect.top -= margin;
                    rect.bottom += margin;
                    decorView.addView((View)ShowcaseTooltip.this.tooltip_view, -2, -2);
                    ShowcaseTooltip.this.tooltip_view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                        public boolean onPreDraw() {
                            ShowcaseTooltip.this.tooltip_view.setup(rect, decorView.getWidth());
                            ShowcaseTooltip.this.tooltip_view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            return false;
                        }
                    });
                }
            }, 100L);
        }
        return this.tooltip_view;
    }

    public ShowcaseTooltip color(int color) {
        this.tooltip_view.setColor(color);
        return this;
    }

    public ShowcaseTooltip color(Paint paint) {
        this.tooltip_view.setPaint(paint);
        return this;
    }

    public ShowcaseTooltip onDisplay(ListenerDisplay listener) {
        this.tooltip_view.setListenerDisplay(listener);
        return this;
    }

    public ShowcaseTooltip padding(int left, int top, int right, int bottom) {
        this.tooltip_view.paddingTop = top;
        this.tooltip_view.paddingBottom = bottom;
        this.tooltip_view.paddingLeft = left;
        this.tooltip_view.paddingRight = right;
        return this;
    }

    public ShowcaseTooltip animation(TooltipAnimation tooltipAnimation) {
        this.tooltip_view.setTooltipAnimation(tooltipAnimation);
        return this;
    }

    public ShowcaseTooltip text(String text) {
        this.tooltip_view.setText(text);
        return this;
    }

    public ShowcaseTooltip text(int text) {
        this.tooltip_view.setText(text);
        return this;
    }

    public ShowcaseTooltip corner(int corner) {
        this.tooltip_view.setCorner(corner);
        return this;
    }

    public ShowcaseTooltip textColor(int textColor) {
        this.tooltip_view.setTextColor(textColor);
        return this;
    }

    public ShowcaseTooltip textTypeFace(Typeface typeface) {
        this.tooltip_view.setTextTypeFace(typeface);
        return this;
    }

    public ShowcaseTooltip textSize(int unit, float textSize) {
        this.tooltip_view.setTextSize(unit, textSize);
        return this;
    }

    public ShowcaseTooltip setTextGravity(int textGravity) {
        this.tooltip_view.setTextGravity(textGravity);
        return this;
    }

    public ShowcaseTooltip distanceWithView(int distance) {
        this.tooltip_view.setDistanceWithView(distance);
        return this;
    }

    public ShowcaseTooltip border(int color, float width) {
        Paint borderPaint = new Paint(1);
        borderPaint.setColor(color);
        borderPaint.setStyle(Paint.Style.STROKE);
        borderPaint.setStrokeWidth(width);
        this.tooltip_view.setBorderPaint(borderPaint);
        return this;
    }

    public static class MyContext {
        private Fragment fragment;
        private Context context;
        private Activity activity;

        public MyContext(Activity activity) {
            this.activity = activity;
        }

        public MyContext(Fragment fragment) {
            this.fragment = fragment;
        }

        public MyContext(Context context) {
            this.context = context;
        }

        public Context getContext() {
            if (this.activity != null) {
                return this.activity;
            }
            return this.fragment.getActivity();
        }

        public Activity getActivity() {
            if (this.activity != null) {
                return this.activity;
            }
            return this.fragment.getActivity();
        }

        public Window getWindow() {
            if (this.activity != null) {
                return this.activity.getWindow();
            }
            if (this.fragment instanceof DialogFragment) {
                return ((DialogFragment)this.fragment).getDialog().getWindow();
            }
            return this.fragment.getActivity().getWindow();
        }
    }

    public static class TooltipView
    extends FrameLayout {
        private static final int MARGIN_SCREEN_BORDER_TOOLTIP = 30;
        private int arrowHeight = 15;
        private int arrowWidth = 15;
        private int arrowSourceMargin = 0;
        private int arrowTargetMargin = 0;
        protected View childView;
        private int color = Color.parseColor((String)"#FFFFFF");
        private Path bubblePath;
        private Paint bubblePaint;
        private Paint borderPaint;
        private Position position = Position.BOTTOM;
        private ALIGN align = ALIGN.CENTER;
        private ListenerDisplay listenerDisplay;
        private TooltipAnimation tooltipAnimation = new FadeTooltipAnimation();
        private int corner = 30;
        private int paddingTop = 20;
        private int paddingBottom = 30;
        private int paddingRight = 60;
        private int paddingLeft = 60;
        private Rect viewRect;
        private int distanceWithView = 0;

        public TooltipView(Context context) {
            super(context);
            this.setWillNotDraw(false);
            this.childView = new TextView(context);
            ((TextView)this.childView).setTextColor(-16777216);
            this.addView(this.childView, -2, -2);
            this.childView.setPadding(0, 0, 0, 0);
            this.bubblePaint = new Paint(1);
            this.bubblePaint.setColor(this.color);
            this.bubblePaint.setStyle(Paint.Style.FILL);
            this.borderPaint = null;
            this.setLayerType(1, this.bubblePaint);
        }

        public void setCustomView(View customView) {
            this.removeView(this.childView);
            this.childView = customView;
            this.addView(this.childView, -2, -2);
        }

        public void setColor(int color) {
            this.color = color;
            this.bubblePaint.setColor(color);
            this.postInvalidate();
        }

        public void setPaint(Paint paint) {
            this.bubblePaint = paint;
            this.setLayerType(1, paint);
            this.postInvalidate();
        }

        public void setPosition(Position position) {
            this.position = position;
            switch (position) {
                case TOP: {
                    this.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom + this.arrowHeight);
                    break;
                }
                case BOTTOM: {
                    this.setPadding(this.paddingLeft, this.paddingTop + this.arrowHeight, this.paddingRight, this.paddingBottom);
                    break;
                }
                case LEFT: {
                    this.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight + this.arrowHeight, this.paddingBottom);
                    break;
                }
                case RIGHT: {
                    this.setPadding(this.paddingLeft + this.arrowHeight, this.paddingTop, this.paddingRight, this.paddingBottom);
                }
            }
            this.postInvalidate();
        }

        public void setAlign(ALIGN align) {
            this.align = align;
            this.postInvalidate();
        }

        public void setText(String text) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setText((CharSequence)Html.fromHtml((String)text));
            }
            this.postInvalidate();
        }

        public void setText(int text) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setText(text);
            }
            this.postInvalidate();
        }

        public void setTextColor(int textColor) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setTextColor(textColor);
            }
            this.postInvalidate();
        }

        public int getArrowHeight() {
            return this.arrowHeight;
        }

        public void setArrowHeight(int arrowHeight) {
            this.arrowHeight = arrowHeight;
            this.postInvalidate();
        }

        public int getArrowWidth() {
            return this.arrowWidth;
        }

        public void setArrowWidth(int arrowWidth) {
            this.arrowWidth = arrowWidth;
            this.postInvalidate();
        }

        public int getArrowSourceMargin() {
            return this.arrowSourceMargin;
        }

        public void setArrowSourceMargin(int arrowSourceMargin) {
            this.arrowSourceMargin = arrowSourceMargin;
            this.postInvalidate();
        }

        public int getArrowTargetMargin() {
            return this.arrowTargetMargin;
        }

        public void setArrowTargetMargin(int arrowTargetMargin) {
            this.arrowTargetMargin = arrowTargetMargin;
            this.postInvalidate();
        }

        public void setTextTypeFace(Typeface textTypeFace) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setTypeface(textTypeFace);
            }
            this.postInvalidate();
        }

        public void setTextSize(int unit, float size) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setTextSize(unit, size);
            }
            this.postInvalidate();
        }

        public void setTextGravity(int textGravity) {
            if (this.childView instanceof TextView) {
                ((TextView)this.childView).setGravity(textGravity);
            }
            this.postInvalidate();
        }

        public void setCorner(int corner) {
            this.corner = corner;
        }

        protected void onSizeChanged(int width, int height, int oldw, int oldh) {
            super.onSizeChanged(width, height, oldw, oldh);
            this.bubblePath = this.drawBubble(new RectF(0.0f, 0.0f, (float)width, (float)height), this.corner, this.corner, this.corner, this.corner);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.bubblePath != null) {
                canvas.drawPath(this.bubblePath, this.bubblePaint);
                if (this.borderPaint != null) {
                    canvas.drawPath(this.bubblePath, this.borderPaint);
                }
            }
        }

        public void setListenerDisplay(ListenerDisplay listener) {
            this.listenerDisplay = listener;
        }

        public void setTooltipAnimation(TooltipAnimation tooltipAnimation) {
            this.tooltipAnimation = tooltipAnimation;
        }

        protected void startEnterAnimation() {
            this.tooltipAnimation.animateEnter((View)this, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (TooltipView.this.listenerDisplay != null) {
                        TooltipView.this.listenerDisplay.onDisplay((View)TooltipView.this);
                    }
                }
            });
        }

        public void setupPosition(Rect rect) {
            int y;
            int x;
            if (this.position == Position.LEFT || this.position == Position.RIGHT) {
                x = this.position == Position.LEFT ? rect.left - this.getWidth() - this.distanceWithView : rect.right + this.distanceWithView;
                y = rect.top + this.getAlignOffset(this.getHeight(), rect.height());
            } else {
                y = this.position == Position.BOTTOM ? rect.bottom + this.distanceWithView : rect.top - this.getHeight() - this.distanceWithView;
                x = rect.left + this.getAlignOffset(this.getWidth(), rect.width());
            }
            this.setTranslationX(x);
            this.setTranslationY(y);
        }

        private int getAlignOffset(int myLength, int hisLength) {
            switch (this.align) {
                case END: {
                    return hisLength - myLength;
                }
                case CENTER: {
                    return (hisLength - myLength) / 2;
                }
            }
            return 0;
        }

        private Path drawBubble(RectF myRect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
            Path path = new Path();
            if (this.viewRect == null) {
                return path;
            }
            topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
            topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
            bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
            bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
            float spacingLeft = 30.0f;
            float spacingTop = this.position == Position.BOTTOM ? (float)this.arrowHeight : 0.0f;
            float spacingRight = 30.0f;
            float spacingBottom = this.position == Position.TOP ? (float)this.arrowHeight : 0.0f;
            float left = spacingLeft + myRect.left;
            float top = spacingTop + myRect.top;
            float right = myRect.right - spacingRight;
            float bottom = myRect.bottom - spacingBottom;
            float centerX = (float)this.viewRect.centerX() - this.getX();
            float arrowSourceX = Arrays.asList(Position.TOP, Position.BOTTOM).contains((Object)this.position) ? centerX + (float)this.arrowSourceMargin : centerX;
            float arrowTargetX = Arrays.asList(Position.TOP, Position.BOTTOM).contains((Object)this.position) ? centerX + (float)this.arrowTargetMargin : centerX;
            float arrowSourceY = Arrays.asList(Position.RIGHT, Position.LEFT).contains((Object)this.position) ? bottom / 2.0f - (float)this.arrowSourceMargin : bottom / 2.0f;
            float arrowTargetY = Arrays.asList(Position.RIGHT, Position.LEFT).contains((Object)this.position) ? bottom / 2.0f - (float)this.arrowTargetMargin : bottom / 2.0f;
            path.moveTo(left + topLeftDiameter / 2.0f, top);
            if (this.position == Position.BOTTOM) {
                path.lineTo(arrowSourceX - (float)this.arrowWidth, top);
                path.lineTo(arrowTargetX, myRect.top);
                path.lineTo(arrowSourceX + (float)this.arrowWidth, top);
            }
            path.lineTo(right - topRightDiameter / 2.0f, top);
            path.quadTo(right, top, right, top + topRightDiameter / 2.0f);
            if (this.position == Position.LEFT) {
                path.lineTo(right, arrowSourceY - (float)this.arrowWidth);
                path.lineTo(myRect.right, arrowTargetY);
                path.lineTo(right, arrowSourceY + (float)this.arrowWidth);
            }
            path.lineTo(right, bottom - bottomRightDiameter / 2.0f);
            path.quadTo(right, bottom, right - bottomRightDiameter / 2.0f, bottom);
            if (this.position == Position.TOP) {
                path.lineTo(arrowSourceX + (float)this.arrowWidth, bottom);
                path.lineTo(arrowTargetX, myRect.bottom);
                path.lineTo(arrowSourceX - (float)this.arrowWidth, bottom);
            }
            path.lineTo(left + bottomLeftDiameter / 2.0f, bottom);
            path.quadTo(left, bottom, left, bottom - bottomLeftDiameter / 2.0f);
            if (this.position == Position.RIGHT) {
                path.lineTo(left, arrowSourceY + (float)this.arrowWidth);
                path.lineTo(myRect.left, arrowTargetY);
                path.lineTo(left, arrowSourceY - (float)this.arrowWidth);
            }
            path.lineTo(left, top + topLeftDiameter / 2.0f);
            path.quadTo(left, top, left + topLeftDiameter / 2.0f, top);
            path.close();
            return path;
        }

        public boolean adjustSize(Rect rect, int screenWidth) {
            Rect r = new Rect();
            this.getGlobalVisibleRect(r);
            boolean changed = false;
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (this.position == Position.LEFT && this.getWidth() > rect.left) {
                layoutParams.width = rect.left - 30 - this.distanceWithView;
                changed = true;
            } else if (this.position == Position.RIGHT && rect.right + this.getWidth() > screenWidth) {
                layoutParams.width = screenWidth - rect.right - 30 - this.distanceWithView;
                changed = true;
            } else if (this.position == Position.TOP || this.position == Position.BOTTOM) {
                int adjustedLeft = rect.left;
                int adjustedRight = rect.right;
                if ((float)rect.centerX() + (float)this.getWidth() / 2.0f > (float)screenWidth) {
                    float diff = (float)rect.centerX() + (float)this.getWidth() / 2.0f - (float)screenWidth;
                    adjustedLeft = (int)((float)adjustedLeft - diff);
                    adjustedRight = (int)((float)adjustedRight - diff);
                    this.setAlign(ALIGN.CENTER);
                    changed = true;
                } else if ((float)rect.centerX() - (float)this.getWidth() / 2.0f < 0.0f) {
                    float diff = -((float)rect.centerX() - (float)this.getWidth() / 2.0f);
                    adjustedLeft = (int)((float)adjustedLeft + diff);
                    adjustedRight = (int)((float)adjustedRight + diff);
                    this.setAlign(ALIGN.CENTER);
                    changed = true;
                }
                if (adjustedLeft < 0) {
                    adjustedLeft = 0;
                }
                if (adjustedRight > screenWidth) {
                    adjustedRight = screenWidth;
                }
                rect.left = adjustedLeft;
                rect.right = adjustedRight;
            }
            this.setLayoutParams(layoutParams);
            this.postInvalidate();
            return changed;
        }

        private void onSetup(Rect myRect) {
            this.setupPosition(myRect);
            this.bubblePath = this.drawBubble(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.corner, this.corner, this.corner, this.corner);
            this.startEnterAnimation();
        }

        public void setup(Rect viewRect, int screenWidth) {
            this.viewRect = new Rect(viewRect);
            final Rect myRect = new Rect(viewRect);
            boolean changed = this.adjustSize(myRect, screenWidth);
            if (!changed) {
                this.onSetup(myRect);
            } else {
                this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        TooltipView.this.onSetup(myRect);
                        TooltipView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        return false;
                    }
                });
            }
        }

        public void removeNow() {
            if (this.getParent() != null) {
                ViewGroup parent = (ViewGroup)this.getParent();
                parent.removeView((View)this);
            }
        }

        public void closeNow() {
            this.removeNow();
        }

        public void setDistanceWithView(int distanceWithView) {
            this.distanceWithView = distanceWithView;
        }

        public void setBorderPaint(Paint borderPaint) {
            this.borderPaint = borderPaint;
            this.postInvalidate();
        }
    }

    public static class FadeTooltipAnimation
    implements TooltipAnimation {
        private long fadeDuration = 400L;

        public FadeTooltipAnimation() {
        }

        public FadeTooltipAnimation(long fadeDuration) {
            this.fadeDuration = fadeDuration;
        }

        @Override
        public void animateEnter(View view, Animator.AnimatorListener animatorListener) {
            view.setAlpha(0.0f);
            view.animate().alpha(1.0f).setDuration(this.fadeDuration).setListener(animatorListener);
        }

        @Override
        public void animateExit(View view, Animator.AnimatorListener animatorListener) {
            view.animate().alpha(0.0f).setDuration(this.fadeDuration).setListener(animatorListener);
        }
    }

    public static interface ListenerDisplay {
        public void onDisplay(View var1);
    }

    public static interface TooltipAnimation {
        public void animateEnter(View var1, Animator.AnimatorListener var2);

        public void animateExit(View var1, Animator.AnimatorListener var2);
    }

    public static enum ALIGN {
        START,
        CENTER,
        END;

    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

