/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import uk.co.deanwild.materialshowcaseview.CircularRevealAnimationFactory;
import uk.co.deanwild.materialshowcaseview.FadeAnimationFactory;
import uk.co.deanwild.materialshowcaseview.IAnimationFactory;
import uk.co.deanwild.materialshowcaseview.IDetachedListener;
import uk.co.deanwild.materialshowcaseview.IShowcaseListener;
import uk.co.deanwild.materialshowcaseview.MaterialShowcaseSequence;
import uk.co.deanwild.materialshowcaseview.PrefsManager;
import uk.co.deanwild.materialshowcaseview.R;
import uk.co.deanwild.materialshowcaseview.ShowcaseConfig;
import uk.co.deanwild.materialshowcaseview.ShowcaseTooltip;
import uk.co.deanwild.materialshowcaseview.shape.CircleShape;
import uk.co.deanwild.materialshowcaseview.shape.NoShape;
import uk.co.deanwild.materialshowcaseview.shape.OvalShape;
import uk.co.deanwild.materialshowcaseview.shape.RectangleShape;
import uk.co.deanwild.materialshowcaseview.shape.Shape;
import uk.co.deanwild.materialshowcaseview.target.Target;
import uk.co.deanwild.materialshowcaseview.target.ViewTarget;

public class MaterialShowcaseView
extends FrameLayout
implements View.OnTouchListener,
View.OnClickListener {
    public static final int DEFAULT_SHAPE_PADDING = 10;
    public static final int DEFAULT_TOOLTIP_MARGIN = 10;
    long DEFAULT_DELAY = 0L;
    long DEFAULT_FADE_TIME = 300L;
    private int mOldHeight;
    private int mOldWidth;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Paint mEraser;
    private Target mTarget;
    private Shape mShape;
    private int mXPosition;
    private int mYPosition;
    private boolean mWasDismissed = false;
    private boolean mWasSkipped = false;
    private int mShapePadding = 10;
    private int tooltipMargin = 10;
    private View mContentBox;
    private TextView mTitleTextView;
    private TextView mContentTextView;
    private TextView mDismissButton;
    private boolean mHasCustomGravity;
    private TextView mSkipButton;
    private int mGravity;
    private int mContentBottomMargin;
    private int mContentTopMargin;
    private boolean mDismissOnTouch = false;
    private boolean mShouldRender = false;
    private boolean mRenderOverNav = false;
    private int mMaskColour;
    private IAnimationFactory mAnimationFactory;
    private boolean mShouldAnimate = true;
    private boolean mUseFadeAnimation = false;
    private long mFadeDurationInMillis = this.DEFAULT_FADE_TIME;
    private Handler mHandler;
    private long mDelayInMillis = this.DEFAULT_DELAY;
    private int mBottomMargin = 0;
    private boolean mSingleUse = false;
    private PrefsManager mPrefsManager;
    List<IShowcaseListener> mListeners;
    private UpdateOnGlobalLayout mLayoutListener;
    private IDetachedListener mDetachedListener;
    private boolean mTargetTouchable = false;
    private boolean mDismissOnTargetTouch = true;
    private boolean isSequence = false;
    private ShowcaseTooltip toolTip;
    private boolean toolTipShown;

    public MaterialShowcaseView(Context context) {
        super(context);
        this.init(context);
    }

    public MaterialShowcaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MaterialShowcaseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public MaterialShowcaseView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.setWillNotDraw(false);
        this.mListeners = new ArrayList<IShowcaseListener>();
        this.mLayoutListener = new UpdateOnGlobalLayout();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mLayoutListener);
        this.setOnTouchListener(this);
        this.mMaskColour = Color.parseColor((String)"#dd335075");
        this.setVisibility(4);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.showcase_content, (ViewGroup)this, true);
        this.mContentBox = contentView.findViewById(R.id.content_box);
        this.mTitleTextView = (TextView)contentView.findViewById(R.id.tv_title);
        this.mContentTextView = (TextView)contentView.findViewById(R.id.tv_content);
        this.mDismissButton = (TextView)contentView.findViewById(R.id.tv_dismiss);
        this.mDismissButton.setOnClickListener((View.OnClickListener)this);
        this.mSkipButton = (TextView)contentView.findViewById(R.id.tv_skip);
        this.mSkipButton.setOnClickListener((View.OnClickListener)this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mShouldRender) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.mBitmap == null || this.mCanvas == null || this.mOldHeight != height || this.mOldWidth != width) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mBitmap);
        }
        this.mOldWidth = width;
        this.mOldHeight = height;
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mCanvas.drawColor(this.mMaskColour);
        if (this.mEraser == null) {
            this.mEraser = new Paint();
            this.mEraser.setColor(-1);
            this.mEraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            this.mEraser.setFlags(1);
        }
        this.mShape.draw(this.mCanvas, this.mEraser, this.mXPosition, this.mYPosition);
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mWasDismissed && this.mSingleUse && this.mPrefsManager != null) {
            this.mPrefsManager.resetShowcase();
        }
        this.notifyOnDismissed();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mDismissOnTouch) {
            this.hide();
        }
        if (this.mTargetTouchable && this.mTarget.getBounds().contains((int)event.getX(), (int)event.getY())) {
            if (this.mDismissOnTargetTouch) {
                this.hide();
            }
            return false;
        }
        return true;
    }

    private void notifyOnDisplayed() {
        if (this.mListeners != null) {
            for (IShowcaseListener listener : this.mListeners) {
                listener.onShowcaseDisplayed(this);
            }
        }
    }

    private void notifyOnDismissed() {
        if (this.mListeners != null) {
            for (IShowcaseListener listener : this.mListeners) {
                listener.onShowcaseDismissed(this);
            }
            this.mListeners.clear();
            this.mListeners = null;
        }
        if (this.mDetachedListener != null) {
            this.mDetachedListener.onShowcaseDetached(this, this.mWasDismissed, this.mWasSkipped);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_dismiss) {
            this.hide();
        } else if (v.getId() == R.id.tv_skip) {
            this.skip();
        }
    }

    public void setGravity(int gravity) {
        boolean bl = this.mHasCustomGravity = 0 != gravity;
        if (this.mHasCustomGravity) {
            this.mGravity = gravity;
            this.mContentBottomMargin = 0;
            this.mContentTopMargin = 0;
        }
        this.applyLayoutParams();
    }

    public void setTarget(Target target) {
        this.mTarget = target;
        this.updateDismissButton();
        if (this.mTarget != null) {
            if (!this.mRenderOverNav && Build.VERSION.SDK_INT >= 21) {
                this.mBottomMargin = this.getSoftButtonsBarSizePort();
                FrameLayout.LayoutParams contentLP = (FrameLayout.LayoutParams)this.getLayoutParams();
                if (contentLP != null && contentLP.bottomMargin != this.mBottomMargin) {
                    contentLP.bottomMargin = this.mBottomMargin;
                }
            }
            Point targetPoint = this.mTarget.getPoint();
            Rect targetBounds = this.mTarget.getBounds();
            this.setPosition(targetPoint);
            int height = this.getMeasuredHeight();
            int midPoint = height / 2;
            int yPos = targetPoint.y;
            int radius = Math.max(targetBounds.height(), targetBounds.width()) / 2;
            if (this.mShape != null) {
                this.mShape.updateTarget(this.mTarget);
                radius = this.mShape.getHeight() / 2;
            }
            if (!this.mHasCustomGravity) {
                if (yPos > midPoint) {
                    this.mContentTopMargin = 0;
                    this.mContentBottomMargin = height - yPos + radius + this.mShapePadding;
                    this.mGravity = 80;
                } else {
                    this.mContentTopMargin = yPos + radius + this.mShapePadding;
                    this.mContentBottomMargin = 0;
                    this.mGravity = 48;
                }
            }
        }
        this.applyLayoutParams();
    }

    private void applyLayoutParams() {
        if (this.mContentBox != null && this.mContentBox.getLayoutParams() != null) {
            FrameLayout.LayoutParams contentLP = (FrameLayout.LayoutParams)this.mContentBox.getLayoutParams();
            boolean layoutParamsChanged = false;
            if (contentLP.bottomMargin != this.mContentBottomMargin) {
                contentLP.bottomMargin = this.mContentBottomMargin;
                layoutParamsChanged = true;
            }
            if (contentLP.topMargin != this.mContentTopMargin) {
                contentLP.topMargin = this.mContentTopMargin;
                layoutParamsChanged = true;
            }
            if (contentLP.gravity != this.mGravity) {
                contentLP.gravity = this.mGravity;
                layoutParamsChanged = true;
            }
            if (layoutParamsChanged) {
                this.mContentBox.setLayoutParams((ViewGroup.LayoutParams)contentLP);
            }
            this.updateToolTip();
        }
    }

    void updateToolTip() {
        if (this.toolTip != null) {
            if (!this.toolTipShown) {
                this.toolTipShown = true;
                int shapeDiameter = this.mShape.getTotalRadius() * 2;
                int toolTipDistance = (shapeDiameter - this.mTarget.getBounds().height()) / 2;
                this.toolTip.show(toolTipDistance += this.tooltipMargin);
            }
            if (this.mGravity == 80) {
                this.toolTip.position(ShowcaseTooltip.Position.TOP);
            } else {
                this.toolTip.position(ShowcaseTooltip.Position.BOTTOM);
            }
        }
    }

    void setPosition(Point point) {
        this.setPosition(point.x, point.y);
    }

    void setPosition(int x, int y) {
        this.mXPosition = x;
        this.mYPosition = y;
    }

    private void setTitleText(CharSequence contentText) {
        if (this.mTitleTextView != null && !contentText.equals("")) {
            this.mContentTextView.setAlpha(0.5f);
            this.mTitleTextView.setText(contentText);
        }
    }

    private void setContentText(CharSequence contentText) {
        if (this.mContentTextView != null) {
            this.mContentTextView.setText(contentText);
        }
    }

    private void setToolTip(ShowcaseTooltip toolTip) {
        this.toolTip = toolTip;
    }

    private void setIsSequence(Boolean isSequenceB) {
        this.isSequence = isSequenceB;
    }

    private void setDismissText(CharSequence dismissText) {
        if (this.mDismissButton != null) {
            this.mDismissButton.setText(dismissText);
            this.updateDismissButton();
        }
    }

    private void setSkipText(CharSequence skipText) {
        if (this.mSkipButton != null) {
            this.mSkipButton.setText(skipText);
            this.updateSkipButton();
        }
    }

    private void setDismissStyle(Typeface dismissStyle) {
        if (this.mDismissButton != null) {
            this.mDismissButton.setTypeface(dismissStyle);
            this.updateDismissButton();
        }
    }

    private void setSkipStyle(Typeface skipStyle) {
        if (this.mSkipButton != null) {
            this.mSkipButton.setTypeface(skipStyle);
            this.updateSkipButton();
        }
    }

    private void setTitleTextColor(int textColour) {
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextColor(textColour);
        }
    }

    private void setContentTextColor(int textColour) {
        if (this.mContentTextView != null) {
            this.mContentTextView.setTextColor(textColour);
        }
    }

    private void setDismissTextColor(int textColour) {
        if (this.mDismissButton != null) {
            this.mDismissButton.setTextColor(textColour);
        }
    }

    private void setShapePadding(int padding) {
        this.mShapePadding = padding;
    }

    private void setTooltipMargin(int margin) {
        this.tooltipMargin = margin;
    }

    private void setDismissOnTouch(boolean dismissOnTouch) {
        this.mDismissOnTouch = dismissOnTouch;
    }

    private void setShouldRender(boolean shouldRender) {
        this.mShouldRender = shouldRender;
    }

    private void setMaskColour(int maskColour) {
        this.mMaskColour = maskColour;
    }

    private void setDelay(long delayInMillis) {
        this.mDelayInMillis = delayInMillis;
    }

    private void setFadeDuration(long fadeDurationInMillis) {
        this.mFadeDurationInMillis = fadeDurationInMillis;
    }

    private void setTargetTouchable(boolean targetTouchable) {
        this.mTargetTouchable = targetTouchable;
    }

    private void setDismissOnTargetTouch(boolean dismissOnTargetTouch) {
        this.mDismissOnTargetTouch = dismissOnTargetTouch;
    }

    private void setUseFadeAnimation(boolean useFadeAnimation) {
        this.mUseFadeAnimation = useFadeAnimation;
    }

    public void addShowcaseListener(IShowcaseListener showcaseListener) {
        if (this.mListeners != null) {
            this.mListeners.add(showcaseListener);
        }
    }

    public void removeShowcaseListener(MaterialShowcaseSequence showcaseListener) {
        if (this.mListeners != null && this.mListeners.contains(showcaseListener)) {
            this.mListeners.remove(showcaseListener);
        }
    }

    void setDetachedListener(IDetachedListener detachedListener) {
        this.mDetachedListener = detachedListener;
    }

    public void setShape(Shape mShape) {
        this.mShape = mShape;
    }

    public void setAnimationFactory(IAnimationFactory animationFactory) {
        this.mAnimationFactory = animationFactory;
    }

    public void setConfig(ShowcaseConfig config) {
        if (config.getDelay() > -1L) {
            this.setDelay(config.getDelay());
        }
        if (config.getFadeDuration() > 0L) {
            this.setFadeDuration(config.getFadeDuration());
        }
        if (config.getContentTextColor() > 0) {
            this.setContentTextColor(config.getContentTextColor());
        }
        if (config.getDismissTextColor() > 0) {
            this.setDismissTextColor(config.getDismissTextColor());
        }
        if (config.getDismissTextStyle() != null) {
            this.setDismissStyle(config.getDismissTextStyle());
        }
        if (config.getMaskColor() > 0) {
            this.setMaskColour(config.getMaskColor());
        }
        if (config.getShape() != null) {
            this.setShape(config.getShape());
        }
        if (config.getShapePadding() > -1) {
            this.setShapePadding(config.getShapePadding());
        }
        if (config.getRenderOverNavigationBar() != null) {
            this.setRenderOverNavigationBar(config.getRenderOverNavigationBar());
        }
    }

    void updateDismissButton() {
        if (this.mDismissButton != null) {
            if (TextUtils.isEmpty((CharSequence)this.mDismissButton.getText())) {
                this.mDismissButton.setVisibility(8);
            } else {
                this.mDismissButton.setVisibility(0);
            }
        }
    }

    void updateSkipButton() {
        if (this.mSkipButton != null) {
            if (TextUtils.isEmpty((CharSequence)this.mSkipButton.getText())) {
                this.mSkipButton.setVisibility(8);
            } else {
                this.mSkipButton.setVisibility(0);
            }
        }
    }

    public boolean hasFired() {
        return this.mPrefsManager.hasFired();
    }

    private void singleUse(String showcaseID) {
        this.mSingleUse = true;
        this.mPrefsManager = new PrefsManager(this.getContext(), showcaseID);
    }

    public void removeFromWindow() {
        if (this.getParent() != null && this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        this.mEraser = null;
        this.mAnimationFactory = null;
        this.mCanvas = null;
        this.mHandler = null;
        this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mLayoutListener);
        this.mLayoutListener = null;
        if (this.mPrefsManager != null) {
            this.mPrefsManager.close();
        }
        this.mPrefsManager = null;
    }

    public boolean show(Activity activity) {
        if (this.mSingleUse) {
            if (this.mPrefsManager.hasFired()) {
                return false;
            }
            this.mPrefsManager.setFired();
        }
        ((ViewGroup)activity.getWindow().getDecorView()).addView((View)this);
        this.setShouldRender(true);
        if (this.toolTip != null) {
            if (!(this.mTarget instanceof ViewTarget)) {
                throw new RuntimeException("The target must be of type: " + ViewTarget.class.getCanonicalName());
            }
            ViewTarget viewTarget = (ViewTarget)this.mTarget;
            this.toolTip.configureTarget((ViewGroup)this, viewTarget.getView());
        }
        this.mHandler = new Handler();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MaterialShowcaseView.this.mShouldAnimate) {
                    MaterialShowcaseView.this.fadeIn();
                } else {
                    MaterialShowcaseView.this.setVisibility(0);
                    MaterialShowcaseView.this.notifyOnDisplayed();
                }
            }
        }, this.mDelayInMillis);
        this.updateDismissButton();
        return true;
    }

    public void hide() {
        this.mWasDismissed = true;
        if (this.mShouldAnimate) {
            this.animateOut();
        } else {
            this.removeFromWindow();
        }
    }

    public void skip() {
        this.mWasSkipped = true;
        if (this.mShouldAnimate) {
            this.animateOut();
        } else {
            this.removeFromWindow();
        }
    }

    public void fadeIn() {
        this.setVisibility(4);
        this.mAnimationFactory.animateInView((View)this, this.mTarget.getPoint(), this.mFadeDurationInMillis, new IAnimationFactory.AnimationStartListener(){

            @Override
            public void onAnimationStart() {
                MaterialShowcaseView.this.setVisibility(0);
                MaterialShowcaseView.this.notifyOnDisplayed();
            }
        });
    }

    public void animateOut() {
        this.mAnimationFactory.animateOutView((View)this, this.mTarget.getPoint(), this.mFadeDurationInMillis, new IAnimationFactory.AnimationEndListener(){

            @Override
            public void onAnimationEnd() {
                MaterialShowcaseView.this.setVisibility(4);
                MaterialShowcaseView.this.removeFromWindow();
            }
        });
    }

    public void resetSingleUse() {
        if (this.mSingleUse && this.mPrefsManager != null) {
            this.mPrefsManager.resetShowcase();
        }
    }

    public static void resetSingleUse(Context context, String showcaseID) {
        PrefsManager.resetShowcase(context, showcaseID);
    }

    public static void resetAll(Context context) {
        PrefsManager.resetAll(context);
    }

    public int getSoftButtonsBarSizePort() {
        int resourceId = this.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return this.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private void setRenderOverNavigationBar(boolean mRenderOverNav) {
        this.mRenderOverNav = mRenderOverNav;
    }

    public static class Builder {
        private static final int CIRCLE_SHAPE = 0;
        private static final int RECTANGLE_SHAPE = 1;
        private static final int NO_SHAPE = 2;
        private static final int OVAL_SHAPE = 3;
        private boolean fullWidth = false;
        private int shapeType = 0;
        final MaterialShowcaseView showcaseView;
        private final Activity activity;

        public Builder(Activity activity) {
            this.activity = activity;
            this.showcaseView = new MaterialShowcaseView((Context)activity);
        }

        public Builder setGravity(int gravity) {
            this.showcaseView.setGravity(gravity);
            return this;
        }

        public Builder setTarget(View target) {
            this.showcaseView.setTarget(new ViewTarget(target));
            return this;
        }

        public Builder setSequence(Boolean isSequence) {
            this.showcaseView.setIsSequence(isSequence);
            return this;
        }

        public Builder setDismissText(int resId) {
            return this.setDismissText(this.activity.getString(resId));
        }

        public Builder setDismissText(CharSequence dismissText) {
            this.showcaseView.setDismissText(dismissText);
            return this;
        }

        public Builder setDismissStyle(Typeface dismissStyle) {
            this.showcaseView.setDismissStyle(dismissStyle);
            return this;
        }

        public Builder setSkipText(int resId) {
            return this.setSkipText(this.activity.getString(resId));
        }

        public Builder setSkipText(CharSequence skipText) {
            this.showcaseView.setSkipText(skipText);
            return this;
        }

        public Builder setSkipStyle(Typeface skipStyle) {
            this.showcaseView.setSkipStyle(skipStyle);
            return this;
        }

        public Builder setContentText(int resId) {
            return this.setContentText(this.activity.getString(resId));
        }

        public Builder setContentText(CharSequence text) {
            this.showcaseView.setContentText(text);
            return this;
        }

        public Builder setTitleText(int resId) {
            return this.setTitleText(this.activity.getString(resId));
        }

        public Builder setTitleText(CharSequence text) {
            this.showcaseView.setTitleText(text);
            return this;
        }

        public Builder setToolTip(ShowcaseTooltip toolTip) {
            this.showcaseView.setToolTip(toolTip);
            return this;
        }

        public Builder setTargetTouchable(boolean targetTouchable) {
            this.showcaseView.setTargetTouchable(targetTouchable);
            return this;
        }

        public Builder setDismissOnTargetTouch(boolean dismissOnTargetTouch) {
            this.showcaseView.setDismissOnTargetTouch(dismissOnTargetTouch);
            return this;
        }

        public Builder setDismissOnTouch(boolean dismissOnTouch) {
            this.showcaseView.setDismissOnTouch(dismissOnTouch);
            return this;
        }

        public Builder setMaskColour(int maskColour) {
            this.showcaseView.setMaskColour(maskColour);
            return this;
        }

        public Builder setTitleTextColor(int textColour) {
            this.showcaseView.setTitleTextColor(textColour);
            return this;
        }

        public Builder setContentTextColor(int textColour) {
            this.showcaseView.setContentTextColor(textColour);
            return this;
        }

        public Builder setDismissTextColor(int textColour) {
            this.showcaseView.setDismissTextColor(textColour);
            return this;
        }

        public Builder setDelay(int delayInMillis) {
            this.showcaseView.setDelay(delayInMillis);
            return this;
        }

        public Builder setFadeDuration(int fadeDurationInMillis) {
            this.showcaseView.setFadeDuration(fadeDurationInMillis);
            return this;
        }

        public Builder setListener(IShowcaseListener listener) {
            this.showcaseView.addShowcaseListener(listener);
            return this;
        }

        public Builder singleUse(String showcaseID) {
            this.showcaseView.singleUse(showcaseID);
            return this;
        }

        public Builder setShape(Shape shape) {
            this.showcaseView.setShape(shape);
            return this;
        }

        public Builder withCircleShape() {
            this.shapeType = 0;
            return this;
        }

        public Builder withOvalShape() {
            this.shapeType = 3;
            return this;
        }

        public Builder withoutShape() {
            this.shapeType = 2;
            return this;
        }

        public Builder setShapePadding(int padding) {
            this.showcaseView.setShapePadding(padding);
            return this;
        }

        public Builder setTooltipMargin(int margin) {
            this.showcaseView.setTooltipMargin(margin);
            return this;
        }

        public Builder withRectangleShape() {
            return this.withRectangleShape(false);
        }

        public Builder withRectangleShape(boolean fullWidth) {
            this.shapeType = 1;
            this.fullWidth = fullWidth;
            return this;
        }

        public Builder renderOverNavigationBar() {
            this.showcaseView.setRenderOverNavigationBar(true);
            return this;
        }

        public Builder useFadeAnimation() {
            this.showcaseView.setUseFadeAnimation(true);
            return this;
        }

        public MaterialShowcaseView build() {
            if (this.showcaseView.mShape == null) {
                switch (this.shapeType) {
                    case 1: {
                        this.showcaseView.setShape(new RectangleShape(this.showcaseView.mTarget.getBounds(), this.fullWidth));
                        break;
                    }
                    default: {
                        this.showcaseView.setShape(new CircleShape(this.showcaseView.mTarget));
                        break;
                    }
                    case 2: {
                        this.showcaseView.setShape(new NoShape());
                        break;
                    }
                    case 3: {
                        this.showcaseView.setShape(new OvalShape(this.showcaseView.mTarget));
                    }
                }
            }
            if (this.showcaseView.mAnimationFactory == null) {
                if (Build.VERSION.SDK_INT >= 21 && !this.showcaseView.mUseFadeAnimation) {
                    this.showcaseView.setAnimationFactory(new CircularRevealAnimationFactory());
                } else {
                    this.showcaseView.setAnimationFactory(new FadeAnimationFactory());
                }
            }
            this.showcaseView.mShape.setPadding(this.showcaseView.mShapePadding);
            return this.showcaseView;
        }

        public MaterialShowcaseView show() {
            this.build().show(this.activity);
            return this.showcaseView;
        }
    }

    private class UpdateOnGlobalLayout
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private UpdateOnGlobalLayout() {
        }

        public void onGlobalLayout() {
            MaterialShowcaseView.this.setTarget(MaterialShowcaseView.this.mTarget);
        }
    }
}

