/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview.shape;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import uk.co.deanwild.materialshowcaseview.shape.Shape;
import uk.co.deanwild.materialshowcaseview.target.Target;

public class OvalShape
implements Shape {
    private int radius = 200;
    private boolean adjustToTarget = true;
    private int padding;

    public OvalShape() {
    }

    public OvalShape(int radius) {
        this.radius = radius;
    }

    public OvalShape(Rect bounds) {
        this(OvalShape.getPreferredRadius(bounds));
    }

    public OvalShape(Target target) {
        this(target.getBounds());
    }

    public static int getPreferredRadius(Rect bounds) {
        return Math.max(bounds.width(), bounds.height()) / 2;
    }

    public boolean isAdjustToTarget() {
        return this.adjustToTarget;
    }

    public void setAdjustToTarget(boolean adjustToTarget) {
        this.adjustToTarget = adjustToTarget;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void draw(Canvas canvas, Paint paint, int x, int y) {
        if (this.radius > 0) {
            float rad = this.radius + this.padding;
            RectF rectF = new RectF((float)x - rad, (float)y - rad / 2.0f, (float)x + rad, (float)y + rad / 2.0f);
            canvas.drawOval(rectF, paint);
        }
    }

    @Override
    public void updateTarget(Target target) {
        if (this.adjustToTarget) {
            this.radius = OvalShape.getPreferredRadius(target.getBounds());
        }
    }

    @Override
    public int getTotalRadius() {
        return this.radius + this.padding;
    }

    @Override
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public int getWidth() {
        return this.radius * 2;
    }

    @Override
    public int getHeight() {
        return this.radius;
    }
}

