/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.animation.AccelerateDecelerateInterpolator;
import uk.co.deanwild.materialshowcaseview.IAnimationFactory;
import uk.co.deanwild.materialshowcaseview.MaterialShowcaseView;

public class CircularRevealAnimationFactory
implements IAnimationFactory {
    private static final String ALPHA = "alpha";
    private static final float INVISIBLE = 0.0f;
    private static final float VISIBLE = 1.0f;
    private final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();

    @Override
    @TargetApi(value=21)
    public void animateInView(View target, Point point, long duration, final IAnimationFactory.AnimationStartListener listener) {
        Animator animator = ViewAnimationUtils.createCircularReveal((View)target, (int)point.x, (int)point.y, (float)0.0f, (float)(target.getWidth() > target.getHeight() ? (float)target.getWidth() : (float)target.getHeight()));
        animator.setDuration(duration).addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    @Override
    @TargetApi(value=21)
    public void animateOutView(View target, Point point, long duration, final IAnimationFactory.AnimationEndListener listener) {
        Animator animator = ViewAnimationUtils.createCircularReveal((View)target, (int)point.x, (int)point.y, (float)(target.getWidth() > target.getHeight() ? (float)target.getWidth() : (float)target.getHeight()), (float)0.0f);
        animator.setDuration(duration).addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    @Override
    public void animateTargetToPoint(MaterialShowcaseView showcaseView, Point point) {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)((Object)showcaseView), (String)"showcaseX", (int[])new int[]{point.x});
        ObjectAnimator yAnimator = ObjectAnimator.ofInt((Object)((Object)showcaseView), (String)"showcaseY", (int[])new int[]{point.y});
        set.playTogether(new Animator[]{xAnimator, yAnimator});
        set.setInterpolator((TimeInterpolator)this.interpolator);
        set.start();
    }
}

