/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview.shape;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import uk.co.deanwild.materialshowcaseview.shape.Shape;
import uk.co.deanwild.materialshowcaseview.target.Target;

public class RectangleShape
implements Shape {
    private boolean fullWidth = false;
    private int width = 0;
    private int height = 0;
    private boolean adjustToTarget = true;
    private Rect rect;

    public RectangleShape(int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    public RectangleShape(Rect bounds) {
        this(bounds, false);
    }

    public RectangleShape(Rect bounds, boolean fullWidth) {
        this.fullWidth = fullWidth;
        this.height = bounds.height();
        this.width = fullWidth ? Integer.MAX_VALUE : bounds.width();
        this.init();
    }

    public boolean isAdjustToTarget() {
        return this.adjustToTarget;
    }

    public void setAdjustToTarget(boolean adjustToTarget) {
        this.adjustToTarget = adjustToTarget;
    }

    private void init() {
        this.rect = new Rect(-this.width / 2, -this.height / 2, this.width / 2, this.height / 2);
    }

    @Override
    public void draw(Canvas canvas, Paint paint, int x, int y, int padding) {
        if (!this.rect.isEmpty()) {
            canvas.drawRect((float)(this.rect.left + x - padding), (float)(this.rect.top + y - padding), (float)(this.rect.right + x + padding), (float)(this.rect.bottom + y + padding), paint);
        }
    }

    @Override
    public void updateTarget(Target target) {
        if (this.adjustToTarget) {
            Rect bounds = target.getBounds();
            this.height = bounds.height();
            this.width = this.fullWidth ? Integer.MAX_VALUE : bounds.width();
            this.init();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

