/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import java.util.LinkedList;
import java.util.Queue;
import uk.co.deanwild.materialshowcaseview.IDetachedListener;
import uk.co.deanwild.materialshowcaseview.MaterialShowcaseView;
import uk.co.deanwild.materialshowcaseview.PrefsManager;
import uk.co.deanwild.materialshowcaseview.ShowcaseConfig;

public class MaterialShowcaseSequence
implements IDetachedListener {
    PrefsManager mPrefsManager;
    Queue<MaterialShowcaseView> mShowcaseQueue;
    private boolean mSingleUse = false;
    Activity mActivity;
    private ShowcaseConfig mConfig;
    private int mSequencePosition = 0;
    private OnSequenceItemShownListener mOnItemShownListener = null;
    private OnSequenceItemDismissedListener mOnItemDismissedListener = null;

    public MaterialShowcaseSequence(Activity activity) {
        this.mActivity = activity;
        this.mShowcaseQueue = new LinkedList<MaterialShowcaseView>();
    }

    public MaterialShowcaseSequence(Activity activity, String sequenceID) {
        this(activity);
        this.singleUse(sequenceID);
    }

    public MaterialShowcaseSequence addSequenceItem(View targetView, String content, String dismissText) {
        this.addSequenceItem(targetView, "", content, dismissText);
        return this;
    }

    public MaterialShowcaseSequence addSequenceItem(View targetView, String title, String content, String dismissText) {
        MaterialShowcaseView sequenceItem = new MaterialShowcaseView.Builder(this.mActivity).setTarget(targetView).setTitleText(title).setDismissText(dismissText).setContentText(content).build();
        if (this.mConfig != null) {
            sequenceItem.setConfig(this.mConfig);
        }
        this.mShowcaseQueue.add(sequenceItem);
        return this;
    }

    public MaterialShowcaseSequence addSequenceItem(MaterialShowcaseView sequenceItem) {
        this.mShowcaseQueue.add(sequenceItem);
        return this;
    }

    public MaterialShowcaseSequence singleUse(String sequenceID) {
        this.mSingleUse = true;
        this.mPrefsManager = new PrefsManager((Context)this.mActivity, sequenceID);
        return this;
    }

    public void setOnItemShownListener(OnSequenceItemShownListener listener) {
        this.mOnItemShownListener = listener;
    }

    public void setOnItemDismissedListener(OnSequenceItemDismissedListener listener) {
        this.mOnItemDismissedListener = listener;
    }

    public boolean hasFired() {
        return this.mPrefsManager.getSequenceStatus() == PrefsManager.SEQUENCE_FINISHED;
    }

    public void start() {
        if (this.mSingleUse) {
            if (this.hasFired()) {
                return;
            }
            this.mSequencePosition = this.mPrefsManager.getSequenceStatus();
            if (this.mSequencePosition > 0) {
                for (int i = 0; i < this.mSequencePosition; ++i) {
                    this.mShowcaseQueue.poll();
                }
            }
        }
        if (this.mShowcaseQueue.size() > 0) {
            this.showNextItem();
        }
    }

    private void showNextItem() {
        if (this.mShowcaseQueue.size() > 0 && !this.mActivity.isFinishing()) {
            MaterialShowcaseView sequenceItem = this.mShowcaseQueue.remove();
            sequenceItem.setDetachedListener(this);
            sequenceItem.show(this.mActivity);
            if (this.mOnItemShownListener != null) {
                this.mOnItemShownListener.onShow(sequenceItem, this.mSequencePosition);
            }
        } else if (this.mSingleUse) {
            this.mPrefsManager.setFired();
        }
    }

    @Override
    public void onShowcaseDetached(MaterialShowcaseView showcaseView, boolean wasDismissed) {
        showcaseView.setDetachedListener(null);
        if (wasDismissed) {
            if (this.mOnItemDismissedListener != null) {
                this.mOnItemDismissedListener.onDismiss(showcaseView, this.mSequencePosition);
            }
            if (this.mPrefsManager != null) {
                ++this.mSequencePosition;
                this.mPrefsManager.setSequenceStatus(this.mSequencePosition);
            }
            this.showNextItem();
        }
    }

    public void setConfig(ShowcaseConfig config) {
        this.mConfig = config;
    }

    public static interface OnSequenceItemDismissedListener {
        public void onDismiss(MaterialShowcaseView var1, int var2);
    }

    public static interface OnSequenceItemShownListener {
        public void onShow(MaterialShowcaseView var1, int var2);
    }
}

