/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.flowtextview;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import uk.co.deanwild.flowtextview.helpers.ClickHandler;
import uk.co.deanwild.flowtextview.helpers.CollisionHelper;
import uk.co.deanwild.flowtextview.helpers.PaintHelper;
import uk.co.deanwild.flowtextview.helpers.SpanParser;
import uk.co.deanwild.flowtextview.listeners.OnLinkClickListener;
import uk.co.deanwild.flowtextview.models.HtmlLink;
import uk.co.deanwild.flowtextview.models.HtmlObject;
import uk.co.deanwild.flowtextview.models.Line;
import uk.co.deanwild.flowtextview.models.Obstacle;

public class FlowTextView
extends RelativeLayout {
    private final PaintHelper mPaintHelper = new PaintHelper();
    private final SpanParser mSpanParser = new SpanParser(this, this.mPaintHelper);
    private final ClickHandler mClickHandler = new ClickHandler(this.mSpanParser);
    private int mColor = -16777216;
    private int pageHeight = 0;
    private TextPaint mTextPaint;
    private TextPaint mLinkPaint;
    private float mTextsize;
    private int mTextColor;
    private Typeface typeFace;
    private int mDesiredHeight;
    private boolean needsMeasure;
    private final ArrayList<Obstacle> obstacles;
    private CharSequence mText;
    private boolean mIsHtml;
    private float mSpacingMult;
    private float mSpacingAdd;
    List<HtmlObject> lineObjects;
    HtmlObject htmlLine;

    public FlowTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTextsize = this.getResources().getDisplayMetrics().scaledDensity * 20.0f;
        this.mTextColor = -16777216;
        this.mDesiredHeight = 100;
        this.needsMeasure = true;
        this.obstacles = new ArrayList();
        this.mText = "";
        this.mIsHtml = false;
        this.lineObjects = new ArrayList<HtmlObject>();
        this.htmlLine = new HtmlObject("", 0, 0, 0.0f, null);
        this.init(context, attrs);
    }

    public FlowTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTextsize = this.getResources().getDisplayMetrics().scaledDensity * 20.0f;
        this.mTextColor = -16777216;
        this.mDesiredHeight = 100;
        this.needsMeasure = true;
        this.obstacles = new ArrayList();
        this.mText = "";
        this.mIsHtml = false;
        this.lineObjects = new ArrayList<HtmlObject>();
        this.htmlLine = new HtmlObject("", 0, 0, 0.0f, null);
        this.init(context, attrs);
    }

    public FlowTextView(Context context) {
        super(context);
        this.mTextsize = this.getResources().getDisplayMetrics().scaledDensity * 20.0f;
        this.mTextColor = -16777216;
        this.mDesiredHeight = 100;
        this.needsMeasure = true;
        this.obstacles = new ArrayList();
        this.mText = "";
        this.mIsHtml = false;
        this.lineObjects = new ArrayList<HtmlObject>();
        this.htmlLine = new HtmlObject("", 0, 0, 0.0f, null);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            this.readAttrs(context, attrs);
        }
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = this.getResources().getDisplayMetrics().density;
        this.mTextPaint.setTextSize(this.mTextsize);
        this.mTextPaint.setColor(this.mTextColor);
        this.mLinkPaint = new TextPaint(1);
        this.mLinkPaint.density = this.getResources().getDisplayMetrics().density;
        this.mLinkPaint.setTextSize(this.mTextsize);
        this.mLinkPaint.setColor(-16776961);
        this.mLinkPaint.setUnderlineText(true);
        this.setBackgroundColor(0);
    }

    private void readAttrs(Context context, AttributeSet attrs) {
        int[] attrsArray = new int[]{16843287, 16843288, 16842901, 16842904};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrsArray);
        this.mSpacingAdd = ta.getDimensionPixelSize(0, 0);
        this.mSpacingMult = ta.getFloat(1, 1.0f);
        this.mTextsize = ta.getDimension(2, this.mTextsize);
        this.mTextColor = ta.getColor(3, -16777216);
        ta.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float mViewWidth = this.getWidth();
        this.obstacles.clear();
        int lowestYCoord = this.findBoxesAndReturnLowestObstacleYCoord();
        String[] blocks = this.mText.toString().split("\n");
        int charOffsetStart = 0;
        int charOffsetEnd = 0;
        int lineIndex = 0;
        float yOffset = 0.0f;
        int lineHeight = this.getLineHeight();
        int paddingTop = this.getPaddingTop();
        this.lineObjects.clear();
        this.mSpanParser.reset();
        for (int block_no = 0; block_no <= blocks.length - 1; ++block_no) {
            String thisBlock = blocks[block_no];
            if (thisBlock.length() <= 0) {
                ++lineIndex;
                charOffsetStart = charOffsetEnd += 2;
                continue;
            }
            while (thisBlock.length() > 0) {
                String thisLineStr;
                int chunkSize;
                float actualWidth;
                yOffset = (float)(this.getPaddingTop() + ++lineIndex * lineHeight) - ((float)this.getLineHeight() + this.mTextPaint.getFontMetrics().ascent);
                Line thisLine = CollisionHelper.calculateLineSpaceForGivenYOffset(yOffset, lineHeight, mViewWidth, this.obstacles);
                float xOffset = thisLine.leftBound;
                float maxWidth = thisLine.rightBound - thisLine.leftBound;
                do {
                    Object[] spans;
                    chunkSize = this.getChunk(thisBlock, maxWidth);
                    int thisCharOffset = charOffsetEnd + chunkSize;
                    thisLineStr = chunkSize > 1 ? thisBlock.substring(0, chunkSize) : "";
                    this.lineObjects.clear();
                    actualWidth = this.mIsHtml ? ((spans = ((Spanned)this.mText).getSpans(charOffsetStart, thisCharOffset, Object.class)).length > 0 ? this.mSpanParser.parseSpans(this.lineObjects, spans, charOffsetStart, thisCharOffset, xOffset) : maxWidth) : maxWidth;
                    if (!(actualWidth > maxWidth)) continue;
                    maxWidth -= 5.0f;
                } while (actualWidth > maxWidth);
                charOffsetEnd += chunkSize;
                if (this.lineObjects.size() <= 0) {
                    this.htmlLine.content = thisLineStr;
                    this.htmlLine.start = 0;
                    this.htmlLine.end = 0;
                    this.htmlLine.xOffset = xOffset;
                    this.htmlLine.paint = this.mTextPaint;
                    this.lineObjects.add(this.htmlLine);
                }
                for (HtmlObject thisHtmlObject : this.lineObjects) {
                    if (thisHtmlObject instanceof HtmlLink) {
                        HtmlLink thisLink = (HtmlLink)thisHtmlObject;
                        float thisLinkWidth = thisLink.paint.measureText(thisHtmlObject.content);
                        this.mSpanParser.addLink(thisLink, yOffset, thisLinkWidth, lineHeight);
                    }
                    this.paintObject(canvas, thisHtmlObject.content, thisHtmlObject.xOffset, yOffset, (Paint)thisHtmlObject.paint);
                    if (!thisHtmlObject.recycle) continue;
                    this.mPaintHelper.recyclePaint(thisHtmlObject.paint);
                }
                if (chunkSize >= 1) {
                    thisBlock = thisBlock.substring(chunkSize, thisBlock.length());
                }
                charOffsetStart = charOffsetEnd;
            }
        }
        yOffset += (float)(lineHeight / 2);
        View child = this.getChildAt(this.getChildCount() - 1);
        if (child != null && child.getTag() != null && child.getTag().toString().equalsIgnoreCase("hideable")) {
            if (yOffset > (float)this.pageHeight) {
                if (yOffset < (float)(this.obstacles.get((int)(this.obstacles.size() - 1)).topLefty - this.getLineHeight())) {
                    child.setVisibility(8);
                } else {
                    child.setVisibility(0);
                }
            } else {
                child.setVisibility(8);
            }
        }
        this.mDesiredHeight = Math.max(lowestYCoord, (int)yOffset);
        if (this.needsMeasure) {
            this.needsMeasure = false;
            this.requestLayout();
        }
    }

    private int findBoxesAndReturnLowestObstacleYCoord() {
        int lowestYCoord = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)child.getLayoutParams();
            Obstacle obstacle = new Obstacle();
            obstacle.topLeftx = child.getLeft() - layoutParams.leftMargin;
            int top = child.getTop();
            obstacle.topLefty = child.getTop();
            obstacle.bottomRightx = obstacle.topLeftx + layoutParams.leftMargin + child.getWidth() + layoutParams.rightMargin;
            obstacle.bottomRighty = obstacle.topLefty + child.getHeight() + layoutParams.bottomMargin;
            this.obstacles.add(obstacle);
            if (obstacle.bottomRighty <= lowestYCoord) continue;
            lowestYCoord = obstacle.bottomRighty;
        }
        return lowestYCoord;
    }

    private int getChunk(String text, float maxWidth) {
        int length = this.mTextPaint.breakText(text, true, maxWidth, null);
        if (length <= 0 || length >= text.length() || text.charAt(length - 1) == ' ') {
            return length;
        }
        if (text.length() > length && text.charAt(length) == ' ') {
            return length + 1;
        }
        int tempLength = length - 1;
        while (text.charAt(tempLength) != ' ') {
            if (--tempLength > 0) continue;
            return length;
        }
        return tempLength + 1;
    }

    private void paintObject(Canvas canvas, String thisLineStr, float xOffset, float yOffset, Paint paint) {
        canvas.drawText(thisLineStr, xOffset, yOffset, paint);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.invalidate();
    }

    public void invalidate() {
        this.needsMeasure = true;
        super.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.getWidth();
        int height = heightMode == 0x40000000 ? heightSize : this.mDesiredHeight;
        this.setMeasuredDimension(width, height);
    }

    public float getTextsize() {
        return this.mTextsize;
    }

    public void setTextSize(float textSize) {
        this.mTextsize = textSize;
        this.mTextPaint.setTextSize(this.mTextsize);
        this.mLinkPaint.setTextSize(this.mTextsize);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
        this.mTextPaint.setColor(this.mTextColor);
        this.invalidate();
    }

    public Typeface getTypeFace() {
        return this.typeFace;
    }

    public void setTypeface(Typeface type) {
        this.typeFace = type;
        this.mTextPaint.setTypeface(this.typeFace);
        this.mLinkPaint.setTypeface(this.typeFace);
        this.invalidate();
    }

    public TextPaint getTextPaint() {
        return this.mTextPaint;
    }

    public void setTextPaint(TextPaint mTextPaint) {
        this.mTextPaint = mTextPaint;
        this.invalidate();
    }

    public TextPaint getLinkPaint() {
        return this.mLinkPaint;
    }

    public void setLinkPaint(TextPaint mLinkPaint) {
        this.mLinkPaint = mLinkPaint;
        this.invalidate();
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setText(CharSequence text) {
        this.mText = text;
        if (text instanceof Spannable) {
            this.mIsHtml = true;
            this.mSpanParser.setSpannable((Spannable)text);
        } else {
            this.mIsHtml = false;
        }
        this.invalidate();
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        if (this.mTextPaint != null) {
            this.mTextPaint.setColor(this.mColor);
        }
        this.mPaintHelper.setColor(this.mColor);
        this.invalidate();
    }

    public OnLinkClickListener getOnLinkClickListener() {
        return this.mClickHandler.getOnLinkClickListener();
    }

    public void setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
        this.mClickHandler.setOnLinkClickListener(onLinkClickListener);
    }

    public int getLineHeight() {
        return Math.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.invalidate();
    }
}

