/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.blur;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.RenderScript;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import android.util.Log;
import com.dpizarro.uipicker.library.blur.PickerUIBlur;

class Blur {
    Blur() {
    }

    public static Bitmap apply(Context context, Bitmap sentBitmap) {
        return Blur.apply(context, sentBitmap, PickerUIBlur.DEFAULT_BLUR_RADIUS, PickerUIBlur.DEFAULT_USE_BLUR_RENDERSCRIPT);
    }

    @SuppressLint(value={"NewApi"})
    public static Bitmap apply(Context context, Bitmap sentBitmap, int radius, boolean useRenderScript) {
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)sentBitmap, (int)(sentBitmap.getWidth() / 2), (int)(sentBitmap.getHeight() / 2), (boolean)false);
        if (useRenderScript) {
            if (Build.VERSION.SDK_INT > 16) {
                RenderScript rs = RenderScript.create((Context)context);
                Allocation input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap);
                Allocation output = Allocation.createTyped((RenderScript)rs, (android.renderscript.Type)input.getType());
                android.renderscript.ScriptIntrinsicBlur script = android.renderscript.ScriptIntrinsicBlur.create((RenderScript)rs, (android.renderscript.Element)android.renderscript.Element.U8_4((RenderScript)rs));
                script.setRadius((float)radius);
                script.setInput(input);
                script.forEach(output);
                output.copyTo(bitmap);
                return bitmap;
            }
            try {
                android.support.v8.renderscript.RenderScript rs = android.support.v8.renderscript.RenderScript.create((Context)context);
                android.support.v8.renderscript.Allocation input = android.support.v8.renderscript.Allocation.createFromBitmap((android.support.v8.renderscript.RenderScript)rs, (Bitmap)bitmap);
                android.support.v8.renderscript.Allocation output = android.support.v8.renderscript.Allocation.createTyped((android.support.v8.renderscript.RenderScript)rs, (Type)input.getType());
                ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((android.support.v8.renderscript.RenderScript)rs, (Element)Element.U8_4((android.support.v8.renderscript.RenderScript)rs));
                script.setRadius((float)radius);
                script.setInput(input);
                script.forEach(output);
                output.copyTo(bitmap);
            }
            catch (Exception e) {
                bitmap = Blur.fastblur(sentBitmap, radius);
            }
            return bitmap;
        }
        return Blur.fastblur(sentBitmap, radius);
    }

    private static Bitmap fastblur(Bitmap bitmap, int radius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pix = new int[w * h];
        Log.e((String)"pix", (String)(w + " " + h + " " + pix.length));
        bitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        Log.e((String)"pix", (String)(w + " " + h + " " + pix.length));
        bitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap;
    }
}

