/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.proxy;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.internal.proxy.ProxyHandler;
import org.subethamail.smtp.internal.proxy.ProxyProtocolV1Handler;
import org.subethamail.smtp.internal.proxy.ProxyProtocolV2Handler;
import org.subethamail.smtp.internal.util.HexUtils;
import org.subethamail.smtp.server.Session;

public class ProxyProtocolV1V2Handler
implements ProxyHandler {
    private static final Logger log = LoggerFactory.getLogger(ProxyProtocolV1V2Handler.class);
    public static final ProxyProtocolV1V2Handler INSTANCE = new ProxyProtocolV1V2Handler(ProxyProtocolV1Handler.INSTANCE, ProxyProtocolV2Handler.INSTANCE);
    ProxyProtocolV1Handler v1;
    ProxyProtocolV2Handler v2;

    public ProxyProtocolV1V2Handler(ProxyProtocolV1Handler v1, ProxyProtocolV2Handler v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public ProxyHandler.ProxyResult handle(InputStream in, OutputStream out, Session session) throws IOException {
        int maxPrefixSize = Math.max(ProxyProtocolV1Handler.prefixSize(), ProxyProtocolV2Handler.prefixSize());
        BufferedInputStream buffered = new BufferedInputStream(in, maxPrefixSize);
        buffered.mark(maxPrefixSize);
        byte[] prefix = new byte[maxPrefixSize];
        int read = buffered.read(prefix, 0, maxPrefixSize);
        if (this.v1.isValidPrefix(prefix)) {
            log.debug("(session {}) Detected PROXY protocol v1 prefix", (Object)session.getSessionId());
            buffered.reset();
            return this.v1.handle(buffered, out, session);
        }
        if (this.v2.isValidPrefix(prefix)) {
            log.debug("(session {}) Detected PROXY protocol v2 prefix", (Object)session.getSessionId());
            buffered.reset();
            return this.v2.handle(buffered, out, session);
        }
        String prefixHex = HexUtils.toHex(prefix, 0, read);
        log.error("(session {}) Invalid PROXY protocol v1 or v2 prefix {}", (Object)session.getSessionId(), (Object)prefixHex);
        throw new IOException("Invalid PROXY protocol v1 or v2 prefix " + prefixHex);
    }
}

