/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.pool.internal;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Single;
import io.reactivex.plugins.RxJavaPlugins;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import org.davidmoten.rx.jdbc.internal.DelegatedConnection;
import org.davidmoten.rx.jdbc.pool.internal.PooledConnection;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.Pool;

public final class ConnectionProviderBlockingPool
implements Pool<Connection> {
    private final ConnectionProvider connectionProvider;

    public ConnectionProviderBlockingPool(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public Single<Member<Connection>> member() {
        return Single.fromCallable(() -> new MemberWithValueConnection(this.connectionProvider));
    }

    public void close() throws Exception {
        this.connectionProvider.close();
    }

    static final class MemberWithValueConnection
    implements Member<Connection>,
    DelegatedConnection {
        private final ConnectionProvider connectionProvider;
        volatile PooledConnection connection;
        final AtomicBoolean hasConnection = new AtomicBoolean();

        public MemberWithValueConnection(ConnectionProvider cp) {
            this.connectionProvider = cp;
        }

        @Override
        public Connection con() {
            if (this.hasConnection.compareAndSet(false, true)) {
                Connection c = this.connectionProvider.get();
                Preconditions.checkNotNull((Object)c, (String)"connectionProvider should not return null");
                this.connection = new PooledConnection(c, (Checkin)this);
            }
            return this.connection;
        }

        public void checkin() {
            try {
                this.connection.con().close();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }

        public Connection value() {
            return this.con();
        }

        public void disposeValue() {
            try {
                this.connection.con().close();
            }
            catch (SQLException e) {
                RxJavaPlugins.onError((Throwable)e);
            }
        }
    }
}

