/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.davidmoten.rx.jdbc.Parameter;
import org.davidmoten.rx.jdbc.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SqlInfo {
    private static final Logger log = LoggerFactory.getLogger(SqlInfo.class);
    private final String sql;
    private final List<String> names;
    private final int numQuestionMarks;

    SqlInfo(String sql, List<String> names) {
        this.sql = sql;
        this.names = names;
        this.numQuestionMarks = names.isEmpty() ? Util.countQuestionMarkParameters(sql) : 0;
    }

    String sql() {
        return this.sql;
    }

    int numParameters() {
        if (this.names.isEmpty()) {
            return this.numQuestionMarks;
        }
        return this.names.size();
    }

    List<String> names() {
        return this.names;
    }

    static SqlInfo parse(String namedSql, List<Parameter> parameters) {
        ArrayList<String> names = new ArrayList<String>();
        String sql = SqlInfo.collectNamesAndConvertToQuestionMarks(namedSql, names, parameters);
        log.debug("sqlAfterSubs={}", (Object)sql);
        return new SqlInfo(sql, names);
    }

    static SqlInfo parse(String namedSql) {
        return SqlInfo.parse(namedSql, Collections.emptyList());
    }

    private static String collectNamesAndConvertToQuestionMarks(String namedSql, List<String> names, List<Parameter> parameters) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            if (!p.hasName()) continue;
            map.put(p.name(), p);
        }
        int length = namedSql.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            char c = namedSql.charAt(i);
            StringBuilder s = new StringBuilder();
            if (inSingleQuote) {
                if (c == '\'') {
                    inSingleQuote = false;
                }
                s.append(c);
            } else if (inDoubleQuote) {
                if (c == '\"') {
                    inDoubleQuote = false;
                }
                s.append(c);
            } else if (c == '\'') {
                inSingleQuote = true;
                s.append(c);
            } else if (c == '\"') {
                inDoubleQuote = true;
                s.append(c);
            } else if (c == ':' && i + 1 < length && !SqlInfo.isFollowedOrPrefixedByColon(namedSql, i) && Character.isJavaIdentifierStart(namedSql.charAt(i + 1))) {
                int j;
                ++count;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(namedSql.charAt(j)); ++j) {
                }
                String name = namedSql.substring(i + 1, j);
                if (!parameters.isEmpty()) {
                    Parameter p = (Parameter)map.get(name);
                    s.append(IntStream.range(0, p.size()).mapToObj(x -> "?").collect(Collectors.joining(",")));
                } else {
                    s.append("?");
                }
                names.add(name);
                i += name.length();
            } else if (c == '?') {
                ++count;
                if (!parameters.isEmpty()) {
                    Parameter p = parameters.get(count - 1);
                    s.append(IntStream.range(0, p.size()).mapToObj(x -> "?").collect(Collectors.joining(",")));
                } else {
                    s.append(c);
                }
            } else {
                s.append(c);
            }
            parsedQuery.append(s.toString());
        }
        return parsedQuery.toString();
    }

    static boolean isFollowedOrPrefixedByColon(String sql, int i) {
        return ':' == sql.charAt(i + 1) || i > 0 && ':' == sql.charAt(i - 1);
    }
}

