/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Parameter;
import org.davidmoten.rx.jdbc.SqlInfo;

abstract class ParametersBuilder<T> {
    private static final Flowable<List<Object>> SINGLE_EMPTY_LIST = Flowable.just(Collections.emptyList());
    private final List<Flowable<List<Object>>> parameterGroups = new ArrayList<Flowable<List<Object>>>();
    private final List<Object> parameterBuffer = new ArrayList<Object>();
    private final SqlInfo sqlInfo;

    ParametersBuilder(@Nonnull String sql) {
        this.sqlInfo = SqlInfo.parse(sql);
    }

    public final T parameterStream(@Nonnull Flowable<?> values) {
        Preconditions.checkNotNull(values);
        if (this.sqlInfo.numParameters() == 0) {
            this.parameterListStream(values.map(x -> Collections.emptyList()));
        } else {
            this.parameterListStream(values.buffer(this.sqlInfo.numParameters()));
        }
        return (T)this;
    }

    public final T parameterListStream(@Nonnull Flowable<List<?>> valueLists) {
        Preconditions.checkNotNull(valueLists, (String)"valueLists cannot be null");
        this.useAndCloseParameterBuffer();
        this.parameterGroups.add(valueLists);
        return (T)this;
    }

    public final T parameters(@Nonnull List<?> values) {
        return this.parameterList(values.toArray());
    }

    public final T parameter(@Nonnull String name, Object value) {
        Preconditions.checkNotNull((Object)name, (String)"name cannot be null");
        this.parameterBuffer.add(new Parameter(name, value));
        return (T)this;
    }

    public final T parameter(Object value) {
        return this.parameters(value);
    }

    public final T parameters(Object ... values) {
        return this.parameterList(values);
    }

    private final T parameterList(Object[] values) {
        Preconditions.checkNotNull((Object)values);
        if (values.length == 0) {
            return (T)this;
        }
        Preconditions.checkArgument((this.sqlInfo.numParameters() == 0 || values.length % this.sqlInfo.numParameters() == 0 ? 1 : 0) != 0, (String)("number of values should be a multiple of number of parameters in sql: " + this.sqlInfo.sql()));
        Preconditions.checkArgument((boolean)Arrays.stream(values).allMatch(o -> this.sqlInfo.names().isEmpty() || o instanceof Parameter && ((Parameter)o).hasName()));
        for (Object val : values) {
            if (val == null) {
                this.parameterBuffer.add(Parameter.NULL);
                continue;
            }
            this.parameterBuffer.add(val);
        }
        return (T)this;
    }

    final Flowable<List<Object>> parameterGroupsToFlowable() {
        this.useAndCloseParameterBuffer();
        Flowable pg = this.parameterGroups.isEmpty() ? SINGLE_EMPTY_LIST : Flowable.concat(this.parameterGroups);
        return pg;
    }

    private void useAndCloseParameterBuffer() {
        if (!this.parameterBuffer.isEmpty()) {
            Flowable p = this.sqlInfo.numParameters() > 0 ? Flowable.fromIterable(new ArrayList<Object>(this.parameterBuffer)).buffer(this.sqlInfo.numParameters()) : Flowable.fromIterable(new ArrayList<Object>(this.parameterBuffer)).map(x -> Collections.emptyList());
            this.parameterGroups.add((Flowable<List<Object>>)p);
            this.parameterBuffer.clear();
        }
    }
}

