/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import org.davidmoten.rx.jdbc.internal.SingletonConnectionProvider;

public interface ConnectionProvider {
    @Nonnull
    public Connection get();

    public void close();

    public static ConnectionProvider from(@Nonnull Connection connection) {
        Preconditions.checkNotNull((Object)connection, (String)"connection  cannot be null");
        return new SingletonConnectionProvider(connection);
    }

    public static ConnectionProvider from(final @Nonnull String url) {
        Preconditions.checkNotNull((Object)url, (String)"url cannot be null");
        return new ConnectionProvider(){

            @Override
            public Connection get() {
                try {
                    return DriverManager.getConnection(url);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }

            @Override
            public void close() {
            }
        };
    }

    public static ConnectionProvider from(final @Nonnull String url, final String username, final String password) {
        Preconditions.checkNotNull((Object)url, (String)"url cannot be null");
        return new ConnectionProvider(){

            @Override
            public Connection get() {
                try {
                    return DriverManager.getConnection(url, username, password);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }

            @Override
            public void close() {
            }
        };
    }

    public static ConnectionProvider from(final @Nonnull String url, final Properties properties) {
        Preconditions.checkNotNull((Object)url, (String)"url cannot be null");
        Preconditions.checkNotNull((Object)properties, (String)"properties cannot be null");
        return new ConnectionProvider(){

            @Override
            public Connection get() {
                try {
                    return DriverManager.getConnection(url, properties);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }

            @Override
            public void close() {
            }
        };
    }
}

