/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.davidmoten.rx.jdbc.Call;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.TransactedCallableBuilder;
import org.davidmoten.rx.jdbc.Type;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.callable.CallableResultSet1;
import org.davidmoten.rx.jdbc.callable.CallableResultSet2;
import org.davidmoten.rx.jdbc.callable.CallableResultSet3;
import org.davidmoten.rx.jdbc.callable.CallableResultSet4;
import org.davidmoten.rx.jdbc.callable.CallableResultSetN;
import org.davidmoten.rx.jdbc.callable.internal.Getter1;
import org.davidmoten.rx.jdbc.callable.internal.Getter2;
import org.davidmoten.rx.jdbc.callable.internal.Getter3;
import org.davidmoten.rx.jdbc.callable.internal.Getter4;
import org.davidmoten.rx.jdbc.callable.internal.GetterN;
import org.davidmoten.rx.jdbc.callable.internal.In;
import org.davidmoten.rx.jdbc.callable.internal.InOut;
import org.davidmoten.rx.jdbc.callable.internal.InParameterPlaceholder;
import org.davidmoten.rx.jdbc.callable.internal.Out;
import org.davidmoten.rx.jdbc.callable.internal.ParameterPlaceholder;
import org.davidmoten.rx.jdbc.tuple.Tuple2;
import org.davidmoten.rx.jdbc.tuple.Tuple3;
import org.davidmoten.rx.jdbc.tuple.Tuple4;
import org.davidmoten.rx.jdbc.tuple.TupleN;

public final class CallableBuilder
implements Getter1 {
    final String sql;
    final List<ParameterPlaceholder> params = new ArrayList<ParameterPlaceholder>();
    Flowable<?> inStream;
    final Single<Connection> connection;
    final Database db;

    public CallableBuilder(String sql, Single<Connection> connection, Database db) {
        this.sql = sql;
        this.connection = connection;
        this.db = db;
    }

    public TransactedCallableBuilder transacted() {
        return new TransactedCallableBuilder(this);
    }

    public Flowable<List<Object>> parameterGroups() {
        int numInParameters = this.params.stream().filter(x -> x instanceof InParameterPlaceholder).collect(Collectors.counting()).intValue();
        if (numInParameters == 0) {
            return this.inStream.map(x -> Collections.singletonList(x));
        }
        return this.inStream.buffer(numInParameters);
    }

    public CallableBuilder in() {
        this.params.add(In.IN);
        return this;
    }

    public Completable input(Flowable<?> f) {
        Preconditions.checkArgument((this.inStream == null ? 1 : 0) != 0, (String)("you can only specify in flowable once, current=" + this.inStream));
        this.inStream = f;
        return this.build();
    }

    public Completable once() {
        return this.input(1);
    }

    public Completable input(Object ... objects) {
        return this.input(Flowable.fromArray((Object[])objects));
    }

    public <T> CallableBuilder1<T> inOut(Type type, Class<T> cls) {
        this.params.add(new InOut(type, cls));
        return new CallableBuilder1<T>(this, cls);
    }

    public <T> CallableBuilder1<T> out(Type type, Class<T> cls) {
        this.params.add(new Out(type, cls));
        return new CallableBuilder1<T>(this, cls);
    }

    @Override
    public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
        return new CallableResultSets1Builder<T>(this, function);
    }

    public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
        return this.get(Util.autoMap(cls));
    }

    private Completable build() {
        return Call.createWithZeroOutParameters(this.connection, this.sql, this.parameterGroups(), this.params).ignoreElements();
    }

    private static <T> List<T> createList(List<T> list, T t) {
        ArrayList<T> r = new ArrayList<T>(list);
        r.add(t);
        return r;
    }

    public static final class CallableResultSetsNBuilder {
        private final CallableBuilder b;
        private final List<Function<? super ResultSet, ?>> functions;

        CallableResultSetsNBuilder(CallableBuilder b, List<Function<? super ResultSet, ?>> functions) {
            this.b = b;
            this.functions = functions;
        }

        public CallableResultSetsNBuilder in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSetN> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public Flowable<CallableResultSetN> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSetsNBuilder inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T> CallableResultSetsNBuilder autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        public CallableResultSetsNBuilder get(Function<? super ResultSet, ?> f) {
            this.functions.add(f);
            return this;
        }

        private Flowable<CallableResultSetN> build() {
            return Call.createWithNResultSets(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.functions, 0).dematerialize();
        }
    }

    public static final class CallableResultSets4Builder<T1, T2, T3, T4>
    implements GetterN {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;
        private final Function<? super ResultSet, ? extends T3> f3;
        private final Function<? super ResultSet, ? extends T4> f4;

        CallableResultSets4Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, Function<? super ResultSet, ? extends T4> f4) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T> CallableResultSetsNBuilder autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public CallableResultSetsNBuilder get(Function<? super ResultSet, ?> f5) {
            return new CallableResultSetsNBuilder(this.b, Lists.newArrayList((Object[])new Function[]{this.f1, this.f2, this.f3, this.f4, f5}));
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> build() {
            return Call.createWithFourResultSets(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, this.f3, this.f4, 0).dematerialize();
        }
    }

    public static final class CallableResultSets3Builder<T1, T2, T3>
    implements Getter4<T1, T2, T3> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;
        private final Function<? super ResultSet, ? extends T3> f3;

        CallableResultSets3Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        public CallableResultSets3Builder<T1, T2, T3> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public CallableResultSets3Builder<T1, T2, T3> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet3<T1, T2, T3>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public Flowable<CallableResultSet3<T1, T2, T3>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets3Builder<T1, T2, T3> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T4> CallableResultSets4Builder<T1, T2, T3, T4> autoMap(Class<T4> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T4> CallableResultSets4Builder<T1, T2, T3, T4> get(Function<? super ResultSet, ? extends T4> f4) {
            return new CallableResultSets4Builder<T1, T2, T3, T4>(this.b, this.f1, this.f2, this.f3, f4);
        }

        private Flowable<CallableResultSet3<T1, T2, T3>> build() {
            return Call.createWithThreeResultSets(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, this.f3, 0).dematerialize();
        }
    }

    public static final class CallableResultSets2Builder<T1, T2>
    implements Getter3<T1, T2> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;

        CallableResultSets2Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
        }

        public CallableResultSets2Builder<T1, T2> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public Flowable<CallableResultSet2<T1, T2>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableResultSets2Builder<T1, T2> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet2<T1, T2>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets2Builder<T1, T2> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T3> CallableResultSets3Builder<T1, T2, T3> autoMap(Class<T3> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T3> CallableResultSets3Builder<T1, T2, T3> get(Function<? super ResultSet, ? extends T3> f3) {
            return new CallableResultSets3Builder<T1, T2, T3>(this.b, this.f1, this.f2, f3);
        }

        private Flowable<CallableResultSet2<T1, T2>> build() {
            return Call.createWithTwoResultSets(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, 0).dematerialize();
        }
    }

    public static final class CallableResultSets1Builder<T1>
    implements Getter2<T1> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;

        CallableResultSets1Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> function) {
            this.b = b;
            this.f1 = function;
        }

        public CallableResultSets1Builder<T1> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public <T2> CallableResultSets2Builder<T1, T2> autoMap(Class<T2> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T2> CallableResultSets2Builder<T1, T2> get(Function<? super ResultSet, ? extends T2> f2) {
            return new CallableResultSets2Builder<T1, T2>(this.b, this.f1, f2);
        }

        public Flowable<CallableResultSet1<T1>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableResultSets1Builder<T1> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet1<T1>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets1Builder<T1> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        private Flowable<CallableResultSet1<T1>> build() {
            return Call.createWithOneResultSet(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, 0).dematerialize();
        }
    }

    public static final class CallableBuilderN
    implements Getter1 {
        private final CallableBuilder b;
        private final List<Class<?>> outClasses;

        public CallableBuilderN(CallableBuilder b, List<Class<?>> outClasses) {
            this.b = b;
            this.outClasses = outClasses;
        }

        public Flowable<TupleN<Object>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableBuilderN in() {
            this.b.in();
            return this;
        }

        public Flowable<TupleN<Object>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableBuilderN out(Type type, Class<?> cls) {
            this.b.out(type, cls);
            return new CallableBuilderN(this.b, CallableBuilder.createList(this.outClasses, cls));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<TupleN<Object>> build() {
            return Call.createWithNParameters(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.outClasses).dematerialize();
        }
    }

    public static final class CallableBuilder4<T1, T2, T3, T4>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;
        private final Class<T3> cls3;
        private final Class<T4> cls4;

        public CallableBuilder4(CallableBuilder b, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
            this.cls3 = cls3;
            this.cls4 = cls4;
        }

        public Flowable<Tuple4<T1, T2, T3, T4>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableBuilder4<T1, T2, T3, T4> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple4<T1, T2, T3, T4>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public CallableBuilderN inOut(Type type, Class<T3> cls5) {
            this.b.inOut(type, cls5);
            return new CallableBuilderN(this.b, Lists.newArrayList((Object[])new Class[]{this.cls1, this.cls2, this.cls3, this.cls4, cls5}));
        }

        public CallableBuilderN out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return new CallableBuilderN(this.b, Lists.newArrayList((Object[])new Class[]{this.cls1, this.cls2, this.cls3, this.cls4, cls5}));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple4<T1, T2, T3, T4>> build() {
            return Call.createWithFourOutParameters(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2, this.cls3, this.cls4).dematerialize();
        }
    }

    public static final class CallableBuilder3<T1, T2, T3>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;
        private final Class<T3> cls3;

        public CallableBuilder3(CallableBuilder b, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
            this.cls3 = cls3;
        }

        public <T4> CallableBuilder4<T1, T2, T3, T4> out(Type type, Class<T4> cls4) {
            this.b.out(type, cls4);
            return new CallableBuilder4<T1, T2, T3, T4>(this.b, this.cls1, this.cls2, this.cls3, cls4);
        }

        public Flowable<Tuple3<T1, T2, T3>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableBuilder3<T1, T2, T3> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple3<T1, T2, T3>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public <T4> CallableBuilder4<T1, T2, T3, T4> inOut(Type type, Class<T4> cls4) {
            this.b.inOut(type, cls4);
            return new CallableBuilder4<T1, T2, T3, T4>(this.b, this.cls1, this.cls2, this.cls3, cls4);
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple3<T1, T2, T3>> build() {
            return Call.createWithThreeOutParameters(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2, this.cls3).dematerialize();
        }
    }

    public static final class CallableBuilder2<T1, T2>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;

        public CallableBuilder2(CallableBuilder b, Class<T1> cls1, Class<T2> cls2) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
        }

        public <T3> CallableBuilder3<T1, T2, T3> out(Type type, Class<T3> cls3) {
            this.b.out(type, cls3);
            return new CallableBuilder3<T1, T2, T3>(this.b, this.cls1, this.cls2, cls3);
        }

        public Flowable<Tuple2<T1, T2>> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public CallableBuilder2<T1, T2> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple2<T1, T2>> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        public <T3> CallableBuilder3<T1, T2, T3> inOut(Type type, Class<T3> cls3) {
            this.b.inOut(type, cls3);
            return new CallableBuilder3<T1, T2, T3>(this.b, this.cls1, this.cls2, cls3);
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple2<T1, T2>> build() {
            return Call.createWithTwoOutParameters(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2).dematerialize();
        }
    }

    public static final class CallableBuilder1<T1>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls;

        public CallableBuilder1(CallableBuilder b, Class<T1> cls) {
            this.b = b;
            this.cls = cls;
        }

        public CallableBuilder1<T1> in() {
            this.b.in();
            return this;
        }

        public <T2> CallableBuilder2<T1, T2> out(Type type, Class<T2> cls2) {
            this.b.out(type, cls2);
            return new CallableBuilder2<T1, T2>(this.b, this.cls, cls2);
        }

        public <T2> CallableBuilder2<T1, T2> inOut(Type type, Class<T2> cls2) {
            this.b.inOut(type, cls2);
            return new CallableBuilder2<T1, T2>(this.b, this.cls, cls2);
        }

        public Flowable<T1> input(Flowable<?> f) {
            this.b.input(f);
            return this.build();
        }

        public Flowable<T1> input(Object ... objects) {
            return this.input(Flowable.fromArray((Object[])objects));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<T1> build() {
            return Call.createWithOneOutParameter(this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls).dematerialize();
        }
    }
}

