/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry.internal;

import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.internal.GeometryUtil;

public final class PointDouble
implements Point {
    private final double x;
    private final double y;

    private PointDouble(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static PointDouble create(double x, double y) {
        return new PointDouble(x, y);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.x, this.y, r);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return r.x1() <= this.x && this.x <= r.x2() && r.y1() <= this.y && this.y <= r.y2();
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public String toString() {
        return "Point [x=" + this.x() + ", y=" + this.y() + "]";
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    @Override
    public double x1() {
        return this.x;
    }

    @Override
    public double y1() {
        return this.y;
    }

    @Override
    public double x2() {
        return this.x;
    }

    @Override
    public double y2() {
        return this.y;
    }

    @Override
    public double area() {
        return 0.0;
    }

    @Override
    public Rectangle add(Rectangle r) {
        return Geometries.rectangle(Math.min(this.x, r.x1()), Math.min(this.y, r.y1()), Math.max(this.x, r.x2()), Math.max(this.y, r.y2()));
    }

    @Override
    public boolean contains(double x, double y) {
        return this.x == x && this.y == y;
    }

    @Override
    public double intersectionArea(Rectangle r) {
        return 0.0;
    }

    @Override
    public double perimeter() {
        return 0.0;
    }

    @Override
    public boolean isDoublePrecision() {
        return true;
    }
}

