/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Factories;
import com.github.davidmoten.rtree.Factory;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.OnSubscribeSearch;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.SelectorMinimalAreaIncrease;
import com.github.davidmoten.rtree.SelectorRStar;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.SplitterQuadratic;
import com.github.davidmoten.rtree.SplitterRStar;
import com.github.davidmoten.rtree.Visualizer;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.Intersects;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.Comparators;
import com.github.davidmoten.rtree.internal.NodeAndEntries;
import com.github.davidmoten.rtree.internal.operators.OperatorBoundedPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class RTree<T, S extends Geometry> {
    private final Optional<? extends Node<T, S>> root;
    private final Context<T, S> context;
    public static final int MAX_CHILDREN_DEFAULT_GUTTMAN = 4;
    public static final int MAX_CHILDREN_DEFAULT_STAR = 4;
    private final int size;
    private static final Func1<Geometry, Boolean> ALWAYS_TRUE = new Func1<Geometry, Boolean>(){

        public Boolean call(Geometry rectangle) {
            return true;
        }
    };
    private static final String marginIncrement = "  ";

    private RTree(Optional<? extends Node<T, S>> root, int size, Context<T, S> context) {
        this.root = root;
        this.size = size;
        this.context = context;
    }

    private RTree() {
        this(Optional.absent(), 0, null);
    }

    private RTree(Node<T, S> root, int size, Context<T, S> context) {
        this(Optional.of(root), size, context);
    }

    static <T, S extends Geometry> RTree<T, S> create(Optional<? extends Node<T, S>> root, int size, Context<T, S> context) {
        return new RTree<T, S>(root, size, context);
    }

    public static <T, S extends Geometry> RTree<T, S> create() {
        return new Builder().create();
    }

    public static <T, S extends Geometry> RTree<T, S> create(List<Entry<T, S>> entries) {
        return new Builder().create(entries);
    }

    public int calculateDepth() {
        return RTree.calculateDepth(this.root);
    }

    private static <T, S extends Geometry> int calculateDepth(Optional<? extends Node<T, S>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return RTree.calculateDepth((Node)root.get(), 0);
    }

    private static <T, S extends Geometry> int calculateDepth(Node<T, S> node, int depth) {
        if (node instanceof Leaf) {
            return depth + 1;
        }
        return RTree.calculateDepth(((NonLeaf)node).child(0), depth + 1);
    }

    public static Builder minChildren(int minChildren) {
        return new Builder().minChildren(minChildren);
    }

    public static Builder maxChildren(int maxChildren) {
        return new Builder().maxChildren(maxChildren);
    }

    public static Builder splitter(Splitter splitter) {
        return new Builder().splitter(splitter);
    }

    public static Builder selector(Selector selector) {
        return new Builder().selector(selector);
    }

    public static Builder star() {
        return new Builder().star();
    }

    public RTree<T, S> add(Entry<? extends T, ? extends S> entry) {
        if (this.root.isPresent()) {
            List<Node<T, S>> nodes = ((Node)this.root.get()).add(entry);
            Node<? extends T, ? extends S> node = nodes.size() == 1 ? nodes.get(0) : this.context.factory().createNonLeaf(nodes, this.context);
            return new RTree<T, S>(node, this.size + 1, this.context);
        }
        Leaf<T, S> node = this.context.factory().createLeaf(Lists.newArrayList((Object[])new Entry[]{entry}), this.context);
        return new RTree<T, S>(node, this.size + 1, this.context);
    }

    public RTree<T, S> add(T value, S geometry) {
        return this.add(this.context.factory().createEntry(value, geometry));
    }

    public RTree<T, S> add(Iterable<Entry<T, S>> entries) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.add(entry);
        }
        return tree;
    }

    public Observable<RTree<T, S>> add(Observable<Entry<T, S>> entries) {
        return entries.scan((Object)this, new Func2<RTree<T, S>, Entry<T, S>, RTree<T, S>>(){

            public RTree<T, S> call(RTree<T, S> tree, Entry<T, S> entry) {
                return tree.add(entry);
            }
        });
    }

    public Observable<RTree<T, S>> delete(Observable<Entry<T, S>> entries, final boolean all) {
        return entries.scan((Object)this, new Func2<RTree<T, S>, Entry<T, S>, RTree<T, S>>(){

            public RTree<T, S> call(RTree<T, S> tree, Entry<T, S> entry) {
                return tree.delete(entry, all);
            }
        });
    }

    public RTree<T, S> delete(Iterable<Entry<T, S>> entries, boolean all) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.delete(entry, all);
        }
        return tree;
    }

    public RTree<T, S> delete(Iterable<Entry<T, S>> entries) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.delete(entry);
        }
        return tree;
    }

    public RTree<T, S> delete(T value, S geometry, boolean all) {
        return this.delete(this.context.factory().createEntry(value, geometry), all);
    }

    public RTree<T, S> delete(T value, S geometry) {
        return this.delete(this.context.factory().createEntry(value, geometry), false);
    }

    public RTree<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        if (this.root.isPresent()) {
            NodeAndEntries<T, S> nodeAndEntries = ((Node)this.root.get()).delete(entry, all);
            if (nodeAndEntries.node().isPresent() && nodeAndEntries.node().get() == this.root.get()) {
                return this;
            }
            return new RTree<T, S>(nodeAndEntries.node(), this.size - nodeAndEntries.countDeleted() - nodeAndEntries.entriesToAdd().size(), this.context).add(nodeAndEntries.entriesToAdd());
        }
        return this;
    }

    public RTree<T, S> delete(Entry<? extends T, ? extends S> entry) {
        return this.delete(entry, false);
    }

    @VisibleForTesting
    Observable<Entry<T, S>> search(Func1<? super Geometry, Boolean> condition) {
        if (this.root.isPresent()) {
            return Observable.create(new OnSubscribeSearch((Node)this.root.get(), condition));
        }
        return Observable.empty();
    }

    public static Func1<Geometry, Boolean> intersects(final Rectangle r) {
        return new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.intersects(r);
            }
        };
    }

    public Observable<Entry<T, S>> search(Rectangle r) {
        return this.search(RTree.intersects(r));
    }

    public Observable<Entry<T, S>> search(Point p) {
        return this.search(p.mbr());
    }

    public Observable<Entry<T, S>> search(Circle circle) {
        return this.search(circle, Intersects.geometryIntersectsCircle);
    }

    public Observable<Entry<T, S>> search(Line line) {
        return this.search(line, Intersects.geometryIntersectsLine);
    }

    public Observable<Entry<T, S>> search(final Rectangle r, final double maxDistance) {
        return this.search((Func1<Geometry, Boolean>)new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) < maxDistance;
            }
        });
    }

    public <R extends Geometry> Observable<Entry<T, S>> search(final R g, final Func2<? super S, ? super R, Boolean> intersects) {
        return this.search(g.mbr()).filter(new Func1<Entry<T, S>, Boolean>(){

            public Boolean call(Entry<T, S> entry) {
                return (Boolean)intersects.call(entry.geometry(), (Object)g);
            }
        });
    }

    public <R extends Geometry> Observable<Entry<T, S>> search(final R g, final double maxDistance, final Func2<? super S, ? super R, Double> distance) {
        return this.search((Func1<Geometry, Boolean>)new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry entry) {
                return entry.distance(g.mbr()) < maxDistance;
            }
        }).filter(new Func1<Entry<T, S>, Boolean>(){

            public Boolean call(Entry<T, S> entry) {
                return (Double)distance.call(entry.geometry(), (Object)g) < maxDistance;
            }
        });
    }

    public Observable<Entry<T, S>> search(Point p, double maxDistance) {
        return this.search(p.mbr(), maxDistance);
    }

    public Observable<Entry<T, S>> nearest(Rectangle r, double maxDistance, int maxCount) {
        return this.search(r, maxDistance).lift(new OperatorBoundedPriorityQueue(maxCount, Comparators.ascendingDistance(r)));
    }

    public Observable<Entry<T, S>> nearest(Point p, double maxDistance, int maxCount) {
        return this.nearest(p.mbr(), maxDistance, maxCount);
    }

    public Observable<Entry<T, S>> entries() {
        return this.search(ALWAYS_TRUE);
    }

    public Visualizer visualize(int width, int height, Rectangle view) {
        return new Visualizer(this, width, height, view);
    }

    public Visualizer visualize(int width, int height) {
        return this.visualize(width, height, this.calculateMaxView(this));
    }

    private Rectangle calculateMaxView(RTree<T, S> tree) {
        return (Rectangle)((Optional)tree.entries().reduce((Object)Optional.absent(), new Func2<Optional<Rectangle>, Entry<T, S>, Optional<Rectangle>>(){

            public Optional<Rectangle> call(Optional<Rectangle> r, Entry<T, S> entry) {
                if (r.isPresent()) {
                    return Optional.of((Object)((Rectangle)r.get()).add(entry.geometry().mbr()));
                }
                return Optional.of((Object)entry.geometry().mbr());
            }
        }).toBlocking().single()).or((Object)Geometries.rectangle(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Optional<? extends Node<T, S>> root() {
        return this.root;
    }

    public Optional<Rectangle> mbr() {
        if (!this.root.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((Node)this.root.get()).geometry().mbr());
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Context<T, S> context() {
        return this.context;
    }

    public String asString() {
        if (!this.root.isPresent()) {
            return "";
        }
        return this.asString((Node)this.root.get(), "");
    }

    private String asString(Node<T, S> node, String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("mbr=");
        s.append(node.geometry());
        s.append('\n');
        if (node instanceof NonLeaf) {
            NonLeaf n = (NonLeaf)node;
            for (int i = 0; i < n.count(); ++i) {
                Node child = n.child(i);
                s.append(this.asString(child, margin + marginIncrement));
            }
        } else {
            Leaf leaf = (Leaf)node;
            for (Entry entry : leaf.entries()) {
                s.append(margin);
                s.append(marginIncrement);
                s.append("entry=");
                s.append(entry);
                s.append('\n');
            }
        }
        return s.toString();
    }

    public static class Builder {
        private static final double DEFAULT_FILLING_FACTOR = 0.4;
        private static final double DEFAULT_LOADING_FACTOR = 0.7;
        private Optional<Integer> maxChildren = Optional.absent();
        private Optional<Integer> minChildren = Optional.absent();
        private Splitter splitter = new SplitterQuadratic();
        private Selector selector = new SelectorMinimalAreaIncrease();
        private double loadingFactor = 0.7;
        private boolean star = false;
        private Factory<Object, Geometry> factory = Factories.defaultFactory();

        private Builder() {
        }

        public Builder loadingFactor(double factor) {
            this.loadingFactor = factor;
            return this;
        }

        public Builder minChildren(int minChildren) {
            this.minChildren = Optional.of((Object)minChildren);
            return this;
        }

        public Builder maxChildren(int maxChildren) {
            this.maxChildren = Optional.of((Object)maxChildren);
            return this;
        }

        public Builder splitter(Splitter splitter) {
            this.splitter = splitter;
            return this;
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder star() {
            this.selector = new SelectorRStar();
            this.splitter = new SplitterRStar();
            this.star = true;
            return this;
        }

        public Builder factory(Factory<?, ? extends Geometry> factory) {
            this.factory = factory;
            return this;
        }

        public <T, S extends Geometry> RTree<T, S> create() {
            this.setDefaultCapacity();
            return new RTree(Optional.absent(), 0, new Context<Object, Geometry>((Integer)this.minChildren.get(), (Integer)this.maxChildren.get(), this.selector, this.splitter, this.factory));
        }

        public <T, S extends Geometry> RTree<T, S> create(List<Entry<T, S>> entries) {
            this.setDefaultCapacity();
            Context<Object, Geometry> context = new Context<Object, Geometry>((Integer)this.minChildren.get(), (Integer)this.maxChildren.get(), this.selector, this.splitter, this.factory);
            return this.packingSTR(entries, true, entries.size(), context);
        }

        private void setDefaultCapacity() {
            if (!this.maxChildren.isPresent()) {
                this.maxChildren = this.star ? Optional.of((Object)4) : Optional.of((Object)4);
            }
            if (!this.minChildren.isPresent()) {
                this.minChildren = Optional.of((Object)((int)Math.round((double)((Integer)this.maxChildren.get()).intValue() * 0.4)));
            }
        }

        private <T, S extends Geometry> RTree<T, S> packingSTR(List<? extends HasGeometry> objects, boolean isLeaf, int size, Context<T, S> context) {
            int capacity = (int)Math.round((double)((Integer)this.maxChildren.get()).intValue() * this.loadingFactor);
            int nodeCount = (int)Math.ceil(1.0 * (double)objects.size() / (double)capacity);
            if (nodeCount == 0) {
                return this.create();
            }
            if (nodeCount == 1) {
                Node<T, S> root = isLeaf ? context.factory().createLeaf(objects, context) : context.factory().createNonLeaf(objects, context);
                return new RTree(Optional.of(root), size, context);
            }
            int nodePerSlice = (int)Math.ceil(Math.sqrt(nodeCount));
            int sliceCapacity = nodePerSlice * capacity;
            int sliceCount = (int)Math.ceil(1.0 * (double)objects.size() / (double)sliceCapacity);
            Collections.sort(objects, new MidComparator(0));
            ArrayList<Node<T, S>> nodes = new ArrayList<Node<T, S>>(nodeCount);
            for (int s = 0; s < sliceCount; ++s) {
                List<? extends HasGeometry> slice = objects.subList(s * sliceCapacity, Math.min((s + 1) * sliceCapacity, objects.size()));
                Collections.sort(slice, new MidComparator(1));
                for (int i = 0; i < slice.size(); i += capacity) {
                    if (isLeaf) {
                        List<? extends HasGeometry> entries = slice.subList(i, Math.min(slice.size(), i + capacity));
                        Leaf<T, S> leaf = context.factory().createLeaf(entries, context);
                        nodes.add(leaf);
                        continue;
                    }
                    List<? extends HasGeometry> children = slice.subList(i, Math.min(slice.size(), i + capacity));
                    NonLeaf<T, S> nonleaf = context.factory().createNonLeaf(children, context);
                    nodes.add(nonleaf);
                }
            }
            return this.packingSTR(nodes, false, size, context);
        }

        private static final class MidComparator
        implements Comparator<HasGeometry> {
            private final short dimension;

            public MidComparator(short dim) {
                this.dimension = dim;
            }

            @Override
            public int compare(HasGeometry o1, HasGeometry o2) {
                return Double.compare(this.mid(o1), this.mid(o2));
            }

            private double mid(HasGeometry o) {
                Rectangle mbr = o.geometry().mbr();
                if (this.dimension == 0) {
                    return (mbr.x1() + mbr.x2()) / 2.0;
                }
                return (mbr.y1() + mbr.y2()) / 2.0;
            }
        }
    }
}

