/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.geometry.Geometry;

final class NodePosition<T, S extends Geometry> {
    private final Node<T, S> node;
    private final int position;

    NodePosition(Node<T, S> node, int position) {
        Preconditions.checkNotNull(node);
        this.node = node;
        this.position = position;
    }

    Node<T, S> node() {
        return this.node;
    }

    int position() {
        return this.position;
    }

    NodePosition<T, S> nextPosition() {
        return new NodePosition<T, S>(this.node, this.position + 1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodePosition [node=");
        builder.append(this.node);
        builder.append(", position=");
        builder.append(this.position);
        builder.append("]");
        return builder.toString();
    }
}

