/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.util.ObjectsHelper;

public final class Entry<T, S extends Geometry>
implements HasGeometry {
    private final T value;
    private final S geometry;

    public Entry(T value, S geometry) {
        Preconditions.checkNotNull(geometry);
        this.value = value;
        this.geometry = geometry;
    }

    public static <T, S extends Geometry> Entry<T, S> entry(T value, S geometry) {
        return new Entry<T, S>(value, geometry);
    }

    public T value() {
        return this.value;
    }

    public S geometry() {
        return this.geometry;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Entry [value=");
        builder.append(this.value);
        builder.append(", geometry=");
        builder.append(this.geometry);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.geometry});
    }

    public boolean equals(Object obj) {
        Optional<Entry> other = ObjectsHelper.asClass(obj, Entry.class);
        if (other.isPresent()) {
            return Objects.equal(this.value, ((Entry)other.get()).value) && Objects.equal(this.geometry, ((Entry)other.get()).geometry);
        }
        return false;
    }
}

