/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Util {
    private Util() {
    }

    public static Rectangle mbr(Collection<? extends HasGeometry> items) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        float minX1 = Float.MAX_VALUE;
        float minY1 = Float.MAX_VALUE;
        float maxX2 = -3.4028235E38f;
        float maxY2 = -3.4028235E38f;
        for (HasGeometry hasGeometry : items) {
            Rectangle r = hasGeometry.geometry().mbr();
            if (r.x1() < minX1) {
                minX1 = r.x1();
            }
            if (r.y1() < minY1) {
                minY1 = r.y1();
            }
            if (r.x2() > maxX2) {
                maxX2 = r.x2();
            }
            if (!(r.y2() > maxY2)) continue;
            maxY2 = r.y2();
        }
        return Rectangle.create(minX1, minY1, maxX2, maxY2);
    }

    static <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 2);
        result.addAll(list);
        result.add(element);
        return result;
    }

    static <T> List<T> remove(List<? extends T> list, List<? extends T> elements) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(elements);
        return result;
    }

    static <T> List<? extends T> replace(List<? extends T> list, T element, List<T> replacements) {
        ArrayList<T> list2 = new ArrayList<T>(list.size() + replacements.size());
        for (T node : list) {
            if (node == element) continue;
            list2.add(node);
        }
        list2.addAll(replacements);
        return list2;
    }
}

