/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodeAndEntries;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class NonLeaf<T, S extends Geometry>
implements Node<T, S> {
    private final List<? extends Node<T, S>> children;
    private final Rectangle mbr;
    private final Context context;

    NonLeaf(List<? extends Node<T, S>> children, Context context) {
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0);
        this.context = context;
        this.children = children;
        this.mbr = Util.mbr(children);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T, S>> subscriber) {
        if (!((Boolean)criterion.call((Object)this.geometry().mbr())).booleanValue()) {
            return;
        }
        for (Node<T, S> child : this.children) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            child.search(criterion, subscriber);
        }
    }

    @Override
    public int count() {
        return this.children.size();
    }

    public List<? extends Node<T, S>> children() {
        return this.children;
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        List<Node<? extends T, ? extends S>> list;
        Node<T, S> child = this.context.selector().select(entry.geometry().mbr(), this.children);
        List<Node<T, S>> children2 = Util.replace(this.children, child, list = child.add(entry));
        if (children2.size() <= this.context.maxChildren()) {
            return Collections.singletonList(new NonLeaf<T, S>(children2, this.context));
        }
        ListPair<Node<? extends T, ? extends S>> pair = this.context.splitter().split(children2, this.context.minChildren());
        return this.makeNonLeaves(pair);
    }

    private List<Node<T, S>> makeNonLeaves(ListPair<? extends Node<T, S>> pair) {
        ArrayList<Node<T, S>> list = new ArrayList<Node<T, S>>();
        list.add(new NonLeaf<T, S>(pair.group1().list(), this.context));
        list.add(new NonLeaf<T, S>(pair.group2().list(), this.context));
        return list;
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        ArrayList addTheseEntries = new ArrayList();
        ArrayList<Node<T, S>> removeTheseNodes = new ArrayList<Node<T, S>>();
        ArrayList<Object> addTheseNodes = new ArrayList<Object>();
        int countDeleted = 0;
        for (Node<T, S> node : this.children) {
            if (!entry.geometry().intersects(node.geometry().mbr())) continue;
            NodeAndEntries<T, S> result = node.delete(entry, all);
            if (result.node().isPresent()) {
                if (result.node().get() == node) continue;
                addTheseNodes.add(result.node().get());
                removeTheseNodes.add(node);
                addTheseEntries.addAll(result.entriesToAdd());
                countDeleted += result.countDeleted();
                if (all) continue;
                break;
            }
            removeTheseNodes.add(node);
            addTheseEntries.addAll(result.entriesToAdd());
            countDeleted += result.countDeleted();
            if (all) continue;
            break;
        }
        if (removeTheseNodes.isEmpty()) {
            return new NodeAndEntries(Optional.of((Object)this), Collections.emptyList(), 0);
        }
        List<Node<T, S>> nodes = Util.remove(this.children, removeTheseNodes);
        nodes.addAll(addTheseNodes);
        if (nodes.size() == 0) {
            return new NodeAndEntries(Optional.absent(), addTheseEntries, countDeleted);
        }
        NonLeaf<T, S> nonLeaf = new NonLeaf<T, S>(nodes, this.context);
        return new NodeAndEntries(Optional.of(nonLeaf), addTheseEntries, countDeleted);
    }
}

