/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodeAndEntries;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class NonLeaf<T>
implements Node<T> {
    private final List<? extends Node<T>> children;
    private final Rectangle mbr;
    private final Context context;

    NonLeaf(List<? extends Node<T>> children, Context context) {
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0);
        this.context = context;
        this.children = children;
        this.mbr = Util.mbr(children);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T>> subscriber) {
        if (!((Boolean)criterion.call((Object)this.geometry().mbr())).booleanValue()) {
            return;
        }
        for (Node<T> child : this.children) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            child.search(criterion, subscriber);
        }
    }

    @Override
    public int count() {
        return this.children.size();
    }

    public List<? extends Node<T>> children() {
        return this.children;
    }

    @Override
    public List<Node<T>> add(Entry<T> entry) {
        List list;
        Node<T> child = this.context.selector().select(entry.geometry().mbr(), this.children);
        List children2 = Util.replace(this.children, child, list = child.add(entry));
        if (children2.size() <= this.context.maxChildren()) {
            return Collections.singletonList(new NonLeaf(children2, this.context));
        }
        ListPair pair = this.context.splitter().split(children2, this.context.minChildren());
        return this.makeNonLeaves(pair);
    }

    private List<Node<T>> makeNonLeaves(ListPair<? extends Node<T>> pair) {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        list.add(new NonLeaf<T>(pair.group1().list(), this.context));
        list.add(new NonLeaf<T>(pair.group2().list(), this.context));
        return list;
    }

    @Override
    public NodeAndEntries<T> delete(Entry<T> entry, boolean all) {
        ArrayList addTheseEntries = new ArrayList();
        ArrayList<Node<T>> removeTheseNodes = new ArrayList<Node<T>>();
        ArrayList<Object> addTheseNodes = new ArrayList<Object>();
        int countDeleted = 0;
        for (Node<T> child : this.children) {
            if (!entry.geometry().intersects(child.geometry().mbr())) continue;
            NodeAndEntries<T> result = child.delete(entry, all);
            if (result.node().isPresent()) {
                if (result.node().get() == child) continue;
                addTheseNodes.add(result.node().get());
                removeTheseNodes.add(child);
                addTheseEntries.addAll(result.entriesToAdd());
                countDeleted += result.countDeleted();
                if (all) continue;
                break;
            }
            removeTheseNodes.add(child);
            addTheseEntries.addAll(result.entriesToAdd());
            countDeleted += result.countDeleted();
            if (all) continue;
            break;
        }
        if (removeTheseNodes.isEmpty()) {
            return new NodeAndEntries(Optional.of((Object)this), Collections.emptyList(), 0);
        }
        List<Node<T>> nodes = Util.remove(this.children, removeTheseNodes);
        nodes.addAll(addTheseNodes);
        if (nodes.size() == 0) {
            return new NodeAndEntries(Optional.absent(), addTheseEntries, countDeleted);
        }
        NonLeaf<T> node = new NonLeaf<T>(nodes, this.context);
        return new NodeAndEntries(Optional.of(node), addTheseEntries, countDeleted);
    }
}

