/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodeAndEntries;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class Leaf<T>
implements Node<T> {
    private final List<Entry<T>> entries;
    private final Rectangle mbr;
    private final Context context;

    Leaf(List<Entry<T>> entries, Context context) {
        this.entries = entries;
        this.context = context;
        this.mbr = Util.mbr(entries);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    List<Entry<T>> entries() {
        return this.entries;
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T>> subscriber) {
        if (!((Boolean)criterion.call((Object)this.geometry().mbr())).booleanValue()) {
            return;
        }
        for (Entry<T> entry : this.entries) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            if (!((Boolean)criterion.call((Object)entry.geometry())).booleanValue()) continue;
            subscriber.onNext(entry);
        }
    }

    @Override
    public int count() {
        return this.entries.size();
    }

    @Override
    public List<Node<T>> add(Entry<T> entry) {
        List<Entry<T>> entries2 = Util.add(this.entries, entry);
        if (entries2.size() <= this.context.maxChildren()) {
            return Collections.singletonList(new Leaf<T>(entries2, this.context));
        }
        ListPair<Entry<T>> pair = this.context.splitter().split(entries2, this.context.minChildren());
        return this.makeLeaves(pair);
    }

    private List<Node<T>> makeLeaves(ListPair<Entry<T>> pair) {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        list.add(new Leaf<T>(pair.group1().list(), this.context));
        list.add(new Leaf<T>(pair.group2().list(), this.context));
        return list;
    }

    @Override
    public NodeAndEntries<T> delete(Entry<T> entry, boolean all) {
        if (!this.entries.contains(entry)) {
            return new NodeAndEntries(Optional.of((Object)this), Collections.emptyList(), 0);
        }
        ArrayList<Entry<T>> entries2 = new ArrayList<Entry<T>>(this.entries);
        entries2.remove(entry);
        int numDeleted = 1;
        while (all && entries2.remove(entry)) {
            ++numDeleted;
        }
        if (entries2.size() >= this.context.minChildren()) {
            Leaf<T> node = new Leaf<T>(entries2, this.context);
            return new NodeAndEntries(Optional.of(node), Collections.emptyList(), numDeleted);
        }
        return new NodeAndEntries<T>(Optional.absent(), entries2, numDeleted);
    }
}

