/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.operators;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.Comparator;
import rx.Observable;
import rx.Subscriber;

public class OperatorBoundedPriorityQueue<T>
implements Observable.Operator<T, T> {
    private final int maximumSize;
    private final Comparator<T> comparator;

    public OperatorBoundedPriorityQueue(int maximumSize, Comparator<T> comparator) {
        this.maximumSize = maximumSize;
        this.comparator = comparator;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final MinMaxPriorityQueue q = MinMaxPriorityQueue.maximumSize((int)this.maximumSize).create();
        return new Subscriber<T>(child){

            public void onCompleted() {
                for (Wrapper w : q) {
                    if (this.isUnsubscribed()) {
                        return;
                    }
                    child.onNext(w.value);
                }
                if (this.isUnsubscribed()) {
                    return;
                }
                child.onCompleted();
            }

            public void onError(Throwable t) {
                if (!this.isUnsubscribed()) {
                    child.onError(t);
                }
            }

            public void onNext(T t) {
                if (!this.isUnsubscribed()) {
                    q.add(new Wrapper(t, OperatorBoundedPriorityQueue.this.comparator));
                }
            }
        };
    }

    private static class Wrapper<S>
    implements Comparable<Wrapper<S>> {
        private final Comparator<S> comparator;
        private final S value;

        Wrapper(S value, Comparator<S> comparator) {
            this.comparator = comparator;
            this.value = value;
        }

        @Override
        public int compareTo(Wrapper<S> w) {
            return this.comparator.compare(this.value, w.value);
        }
    }
}

