/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.util.ObjectsHelper;
import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class Circle
implements Geometry {
    private final float x;
    private final float y;
    private final float radius;
    private final Rectangle mbr;

    public Circle(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.mbr = Rectangle.create(x - radius, y - radius, x + radius, y + radius);
    }

    public static Circle create(double x, double y, double radius) {
        return new Circle((float)x, (float)y, (float)radius);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    @Override
    public Rectangle mbr() {
        return this.mbr;
    }

    @Override
    public double distance(Rectangle r) {
        return Math.max(0.0, new Point(this.x, this.y).distance(r) - (double)this.radius);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return new Point(this.x, this.y).distance(r) <= (double)this.radius;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.radius)});
    }

    public boolean equals(Object obj) {
        Optional<Circle> other = ObjectsHelper.asClass(obj, Circle.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x), (Object)Float.valueOf(((Circle)other.get()).x)) && Objects.equal((Object)Float.valueOf(this.y), (Object)Float.valueOf(((Circle)other.get()).y)) && Objects.equal((Object)Float.valueOf(this.radius), (Object)Float.valueOf(((Circle)other.get()).radius));
        }
        return false;
    }
}

