/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public class NearBSpline
implements Shape,
Cloneable {
    private GeneralPath path;
    private Shape lastPart;
    private Shape[] segments;

    public NearBSpline() {
    }

    public NearBSpline(Point2D[] points) {
        this.setLine(points);
    }

    public void setLine(int ... points) {
        double[] pd = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            pd[i] = points[i];
        }
        this.setLine(pd);
    }

    public void setLine(double ... points) {
        this.path = new GeneralPath();
        this.path.moveTo((float)points[0], (float)points[1]);
        this.segments = new Shape[points.length / 2 - 1];
        int i = 2;
        block5: while (i < points.length) {
            switch (points.length - i) {
                case 2: {
                    this.lastPart = new Line2D.Float((float)this.path.getCurrentPoint().getX(), (float)this.path.getCurrentPoint().getY(), (float)points[i], (float)points[i + 1]);
                    this.path.append(this.lastPart, true);
                    this.segments[i / 2 - 1] = this.lastPart;
                    i += 2;
                    continue block5;
                }
                case 4: {
                    this.lastPart = new QuadCurve2D.Float((float)this.path.getCurrentPoint().getX(), (float)this.path.getCurrentPoint().getY(), (float)points[i], (float)points[i + 1], (float)points[i + 2], (float)points[i + 3]);
                    this.path.append(this.lastPart, true);
                    this.segments[i / 2 - 1] = this.lastPart;
                    this.segments[i / 2] = this.lastPart;
                    i += 4;
                    continue block5;
                }
                case 6: {
                    this.lastPart = new CubicCurve2D.Double(this.path.getCurrentPoint().getX(), this.path.getCurrentPoint().getY(), points[i], points[i + 1], points[i + 2], points[i + 3], points[i + 4], points[i + 5]);
                    this.path.append(this.lastPart, true);
                    this.segments[i / 2 - 1] = this.lastPart;
                    this.segments[i / 2] = this.lastPart;
                    this.segments[i / 2 + 1] = this.lastPart;
                    i += 6;
                    continue block5;
                }
            }
            float x = (float)(points[i + 2] + points[i + 4]) / 2.0f;
            float y = (float)(points[i + 3] + points[i + 5]) / 2.0f;
            this.lastPart = new CubicCurve2D.Double(this.path.getCurrentPoint().getX(), this.path.getCurrentPoint().getY(), points[i], points[i + 1], points[i + 2], points[i + 3], x, y);
            this.path.append(this.lastPart, true);
            this.segments[i / 2 - 1] = this.lastPart;
            this.segments[i / 2] = this.lastPart;
            i += 4;
        }
    }

    public void setLine(Point2D[] points) {
        double[] pd = new double[points.length * 2];
        for (int i = 0; i < points.length; ++i) {
            Point2D p = points[i];
            pd[i * 2] = p.getX();
            pd[i * 2 + 1] = p.getY();
        }
        this.setLine(pd);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.path.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.path.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }

    public Shape getLastPart() {
        return this.lastPart;
    }

    public Shape getSegment(int i) {
        return this.segments[i];
    }

    public GeneralPath getPath() {
        return this.path;
    }
}

