/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.projection;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.FeatureUtil;
import com.github.davidmoten.grumpy.projection.ProjectorBounds;
import com.github.davidmoten.grumpy.projection.ProjectorTarget;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Point2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Projector {
    private final ProjectorTarget target;
    private final ProjectorBounds bounds;
    private final MathTransform transform;
    private final GeometryFactory geometryFactory;

    public Projector(ProjectorBounds bounds, ProjectorTarget target) {
        this.target = target;
        this.bounds = bounds;
        try {
            this.transform = CRS.findMathTransform((CoordinateReferenceSystem)FeatureUtil.getCrs("EPSG:4326"), (CoordinateReferenceSystem)FeatureUtil.getCrs(bounds.getSrs()));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        this.geometryFactory = new GeometryFactory();
    }

    public ProjectorBounds getBounds() {
        return this.bounds;
    }

    public ProjectorTarget getTarget() {
        return this.target;
    }

    public Point getGeometryPointInSrs(double lat, double lon) {
        Coordinate coordinate = new Coordinate(lon, lat);
        Point point = this.geometryFactory.createPoint(coordinate);
        try {
            return (Point)JTS.transform((Geometry)point, (MathTransform)this.transform);
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }

    public Point getGeometryPointInSrsRelativeTo(double lat, double lon, double relativeLat, double relativeLon, double relativeX, double relativeY) {
        double x;
        double diffLon1 = lon - relativeLon;
        double diffLon2 = lon - relativeLon + 360.0;
        if (Math.abs(diffLon1) > Math.abs(diffLon2)) {
            lon += 360.0;
        }
        double sign = Math.signum(lon - relativeLon);
        Point point = this.getGeometryPointInSrs(lat, lon);
        double periodAtLat = this.periodAtLat(lat);
        if (sign >= 0.0) {
            while (x - periodAtLat >= relativeX) {
                x -= periodAtLat;
            }
            while (x < relativeX) {
                x += periodAtLat;
            }
        } else {
            for (x = point.getX(); x >= relativeX; x -= periodAtLat) {
            }
            while (x + periodAtLat < relativeX) {
                x += periodAtLat;
            }
        }
        return this.createPoint(x, point.getY());
    }

    public Point createPoint(double x, double y) {
        return this.geometryFactory.createPoint(new Coordinate(x, y));
    }

    public double periodAtLat(double lat) {
        return this.getGeometryPointInSrs(lat, 180.0).getX() - this.getGeometryPointInSrs(lat, -180.0).getX();
    }

    public Point2D.Double getTargetPoint(Point point) {
        double proportionX = (point.getX() - this.bounds.getMinX()) / (this.bounds.getMaxX() - this.bounds.getMinX());
        double proportionY = (this.bounds.getMaxY() - point.getY()) / (this.bounds.getMaxY() - this.bounds.getMinY());
        double x = proportionX * (double)this.target.getWidth();
        double y = proportionY * (double)this.target.getHeight();
        return new Point2D.Double(x, y);
    }

    public Point getFirstXAfter(Projector projector, double lat, double lon, double x) {
        Point point = projector.getGeometryPointInSrs(lat, lon);
        double x2 = point.getX();
        double periodX = this.periodAtLat(lat);
        while (x2 - periodX >= x) {
            x2 -= periodX;
        }
        while (x2 + periodX < x) {
            x2 += periodX;
        }
        return this.createPoint(x2, point.getY());
    }

    public java.awt.Point toPoint(double lat, double lon) {
        Point2D.Double point2D = this.toPoint2D(lat, lon);
        java.awt.Point p = new java.awt.Point();
        p.x = (int)Math.round(((Point2D)point2D).getX());
        p.y = (int)Math.round(((Point2D)point2D).getY());
        return p;
    }

    public Point2D.Double toPointInSrs(double lat, double lon) {
        Point point = this.getGeometryPointInSrs(lat, lon);
        return new Point2D.Double(point.getX(), point.getY());
    }

    public Point2D.Double toPoint2D(double lat, double lon) {
        Coordinate coordinate = new Coordinate(lon, lat);
        Point point = this.geometryFactory.createPoint(coordinate);
        try {
            double proportionX;
            point = (Point)JTS.transform((Geometry)point, (MathTransform)this.transform);
            if (point.getX() > this.bounds.getMaxX() || point.getX() < this.bounds.getMinX()) {
                Coordinate c = new Coordinate(180.0, 0.0);
                Point pt = (Point)JTS.transform((Geometry)this.geometryFactory.createPoint(c), (MathTransform)this.transform);
                double maximumX = pt.getX();
                proportionX = point.getX() > this.bounds.getMaxX() ? (point.getX() - 2.0 * maximumX - this.bounds.getMinX()) / (this.bounds.getMaxX() - this.bounds.getMinX()) : (point.getX() + 2.0 * maximumX - this.bounds.getMinX()) / (this.bounds.getMaxX() - this.bounds.getMinX());
            } else {
                proportionX = (point.getX() - this.bounds.getMinX()) / (this.bounds.getMaxX() - this.bounds.getMinX());
            }
            double proportionY = (this.bounds.getMaxY() - point.getY()) / (this.bounds.getMaxY() - this.bounds.getMinY());
            Point2D.Double point2D = new Point2D.Double(proportionX * (double)this.target.getWidth(), proportionY * (double)this.target.getHeight());
            return point2D;
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }

    public Position toPosition(double targetX, double targetY) {
        double proportionX = targetX / (double)this.target.getWidth();
        double proportionY = targetY / (double)this.target.getHeight();
        double x = proportionX * (this.bounds.getMaxX() - this.bounds.getMinX()) + this.bounds.getMinX();
        double y = this.bounds.getMaxY() - proportionY * (this.bounds.getMaxY() - this.bounds.getMinY());
        Coordinate coordinate = new Coordinate(x, y);
        Point point = this.geometryFactory.createPoint(coordinate);
        try {
            point = (Point)JTS.transform((Geometry)point, (MathTransform)this.transform.inverse());
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return new Position(point.getY(), point.getX());
    }

    public Position toPositionFromSrs(double x, double y) {
        return FeatureUtil.convertToLatLon(x, y, this.bounds.getSrs());
    }

    public String toString() {
        return "ProjectorImpl [target=" + this.target + ", bounds=" + this.bounds + "]";
    }
}

