/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.CapabilitiesLayer;
import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.LayerFeatures;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class Capabilities {
    private final String serviceName;
    private final String serviceTitle;
    private final String serviceAbstract;
    private final Integer serviceMaxWidth;
    private final Integer serviceMaxHeight;
    private final List<String> imageFormats;
    private final List<String> infoFormats;
    private final List<CapabilitiesLayer> layers;
    private final String serviceUrlBase;

    private Capabilities(String serviceName, String serviceTitle, String serviceAbstract, Integer serviceMaxWidth, Integer serviceMaxHeight, List<String> imageFormats, List<String> infoFormats, List<CapabilitiesLayer> layers, String serviceUrlBase) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
        Preconditions.checkNotNull(imageFormats, (Object)"imageFormats cannot be null");
        Preconditions.checkNotNull(infoFormats, (Object)"infoFormats cannot be null");
        Preconditions.checkNotNull(layers, (Object)"layers cannot be null");
        Preconditions.checkNotNull((Object)serviceUrlBase, (Object)"serviceUrlBase cannot be null");
        this.serviceName = serviceName;
        this.serviceTitle = Capabilities.nvl(serviceTitle, serviceName);
        this.serviceAbstract = Capabilities.nvl(serviceAbstract, serviceName);
        this.serviceMaxWidth = serviceMaxWidth;
        this.serviceMaxHeight = serviceMaxHeight;
        this.imageFormats = imageFormats;
        this.infoFormats = infoFormats;
        this.layers = layers;
        this.serviceUrlBase = serviceUrlBase;
    }

    private static <T> T nvl(T v, T w) {
        if (v == null) {
            return w;
        }
        return v;
    }

    public String getServiceTitle() {
        return this.serviceTitle;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceAbstract() {
        return this.serviceAbstract;
    }

    public Integer getServiceMaxWidth() {
        return this.serviceMaxWidth;
    }

    public Integer getServiceMaxHeight() {
        return this.serviceMaxHeight;
    }

    public List<String> getImageFormats() {
        return this.imageFormats;
    }

    public List<String> getInfoFormats() {
        return this.infoFormats;
    }

    public List<CapabilitiesLayer> getLayers() {
        return this.layers;
    }

    public String getServiceUrlBase() {
        return this.serviceUrlBase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String serviceName;
        private String serviceTitle;
        private String serviceAbstract;
        private Integer serviceMaxWidth = 2000;
        private Integer serviceMaxHeight = 2000;
        private List<String> imageFormats = new ArrayList<String>();
        private List<String> infoFormats = new ArrayList<String>();
        private List<CapabilitiesLayer> layers = new ArrayList<CapabilitiesLayer>();
        private String serviceUrlBase;

        private Builder() {
        }

        public Builder serviceBaseUrl(String serviceUrlBase) {
            this.serviceUrlBase = serviceUrlBase;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serviceTitle(String serviceTitle) {
            this.serviceTitle = serviceTitle;
            return this;
        }

        public Builder serviceAbstract(String serviceAbstract) {
            this.serviceAbstract = serviceAbstract;
            return this;
        }

        public Builder serviceMaxWidth(Integer serviceMaxWidth) {
            this.serviceMaxWidth = serviceMaxWidth;
            return this;
        }

        public Builder serviceMaxHeight(Integer serviceMaxHeight) {
            this.serviceMaxHeight = serviceMaxHeight;
            return this;
        }

        public Builder imageFormats(List<String> imageFormats) {
            this.imageFormats = imageFormats;
            return this;
        }

        public Builder imageFormat(String imageFormat) {
            this.imageFormats.add(imageFormat);
            return this;
        }

        public Builder infoFormats(List<String> infoFormats) {
            this.infoFormats = infoFormats;
            return this;
        }

        public Builder infoFormat(String infoFormat) {
            this.infoFormats.add(infoFormat);
            return this;
        }

        public Builder layers(List<CapabilitiesLayer> layers) {
            this.layers = layers;
            return this;
        }

        public Builder layer(CapabilitiesLayer layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder layerFeatures(LayerFeatures layerFeatures) {
            this.layers.add(CapabilitiesLayer.from(layerFeatures).build());
            return this;
        }

        public Builder layerFeatures(Layer layer) {
            return this.layerFeatures(layer.getFeatures());
        }

        public Capabilities build() {
            if (this.serviceTitle == null) {
                this.serviceTitle = this.serviceName;
            }
            if (this.serviceAbstract == null) {
                this.serviceAbstract = this.serviceName;
            }
            return new Capabilities(this.serviceName, this.serviceTitle, this.serviceAbstract, this.serviceMaxWidth, this.serviceMaxHeight, this.imageFormats, this.infoFormats, this.layers, this.serviceUrlBase);
        }
    }
}

