/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms.layer.darkness;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.wms.layer.darkness.TimeUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SunUtil {
    private static Logger log = LoggerFactory.getLogger(SunUtil.class);
    private static final double EARTH_RADIUS_KM = 6378.0;

    private SunUtil() {
    }

    public static Twilight getTwilight(double sunDistanceRadians) {
        double altDegrees = 90.0 - Math.toDegrees(sunDistanceRadians);
        if (altDegrees >= 0.0) {
            return Twilight.DAYLIGHT;
        }
        if (altDegrees >= -6.0) {
            return Twilight.CIVIL;
        }
        if (altDegrees >= -12.0) {
            return Twilight.NAUTICAL;
        }
        if (altDegrees >= -18.0) {
            return Twilight.ASTRONOMICAL;
        }
        return Twilight.NIGHT;
    }

    public static Twilight getTwilight(Position subSolarPoint, Position somePosition) {
        double distKm = somePosition.getDistanceToKm(subSolarPoint);
        double distRads = distKm / 6378.0;
        return SunUtil.getTwilight(distRads);
    }

    public static Position getSubSolarPoint() {
        return SunUtil.getSubSolarPoint(GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT")));
    }

    public static Position getSubSolarPoint(Calendar time) {
        double jd = TimeUtil.getJulianDayNumber(time);
        double T = (jd - 2451545.0) / 36525.0;
        double M = 357.5291 + 35999.0503 * T - 1.559E-4 * T * T - 4.8E-7 * T * T * T;
        double L0 = 280.46645 + 36000.76983 * T + 3.032E-4 * T * T;
        double DL = (1.9146 - 0.004817 * T - 1.4E-5 * T * T) * Math.sin(Math.toRadians(M)) + (0.019993 - 1.01E-4 * T) * Math.sin(Math.toRadians(2.0 * M)) + 2.9E-4 * Math.sin(Math.toRadians(3.0 * M));
        double L = L0 + DL;
        double eps = 23.43929111111111 - (46.815 * T + 5.9E-4 * T * T - 0.001813 * T * T * T) / 3600.0;
        double X = Math.cos(Math.toRadians(L));
        double Y = Math.cos(Math.toRadians(eps)) * Math.sin(Math.toRadians(L));
        double Z = Math.sin(Math.toRadians(eps)) * Math.sin(Math.toRadians(L));
        double R = Math.sqrt(1.0 - Z * Z);
        double delta = Math.toDegrees(Math.atan(Z / R));
        double p = Y / (X + R);
        double ra = Math.toDegrees(Math.atan(p));
        double RA = 0.13333333333333333 * ra;
        double theta0 = 280.46061837 + 360.98564736629 * (jd - 2451545.0) + 3.87933E-4 * T * T - T * T * T / 3.871E7;
        double sidTime = theta0 % 360.0 / 15.0;
        double sunHADeg = (sidTime - RA) * 15.0 % 360.0;
        double lon = 0.0;
        lon = sunHADeg < 180.0 ? -sunHADeg : 360.0 - sunHADeg;
        double lat = delta;
        log.info("Sidereal time is " + sidTime + ", Sun RA/Dec is " + RA + "/" + delta + ", subSolar lat/long is " + lat + "/" + lon);
        return new Position(lat, lon);
    }

    public static enum Twilight {
        NIGHT,
        ASTRONOMICAL,
        NAUTICAL,
        CIVIL,
        DAYLIGHT;

    }
}

