/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.AvroExtension;
import com.github.davidmc24.gradle.plugin.avro.DefaultAvroExtension;
import com.github.davidmc24.gradle.plugin.avro.GenerateAvroJavaTask;
import com.github.davidmc24.gradle.plugin.avro.GradleCompatibility;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AvroBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        AvroBasePlugin.configureExtension(project);
    }

    private static void configureExtension(Project project) {
        AvroExtension avroExtension = GradleCompatibility.createExtensionWithObjectFactory(project, "avro", DefaultAvroExtension.class);
        project.getTasks().withType(GenerateAvroJavaTask.class).configureEach(task -> {
            task.getOutputCharacterEncoding().convention(avroExtension.getOutputCharacterEncoding());
            task.getStringType().convention(avroExtension.getStringType());
            task.getFieldVisibility().convention(avroExtension.getFieldVisibility());
            task.getTemplateDirectory().convention(avroExtension.getTemplateDirectory());
            task.isCreateSetters().convention(avroExtension.isCreateSetters());
            task.isCreateOptionalGetters().convention(avroExtension.isCreateOptionalGetters());
            task.isGettersReturnOptional().convention(avroExtension.isGettersReturnOptional());
            task.isOptionalGettersForNullableFieldsOnly().convention(avroExtension.isOptionalGettersForNullableFieldsOnly());
            task.isEnableDecimalLogicalType().convention(avroExtension.isEnableDecimalLogicalType());
            task.getLogicalTypeFactories().convention(avroExtension.getLogicalTypeFactories());
            task.getCustomConversions().convention(avroExtension.getCustomConversions());
        });
    }
}

