/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.FileState;
import com.github.davidmc24.gradle.plugin.avro.MapUtils;
import com.github.davidmc24.gradle.plugin.avro.ProcessingState;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.gradle.api.GradleException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;

class SchemaResolver {
    private static Pattern ERROR_UNKNOWN_TYPE = Pattern.compile("(?i).*(undefined name|not a defined name|type not supported).*");
    private static Pattern ERROR_DUPLICATE_TYPE = Pattern.compile("Can't redefine: (.*)");
    private final ProjectLayout projectLayout;
    private final Logger logger;

    SchemaResolver(ProjectLayout projectLayout, Logger logger) {
        this.projectLayout = projectLayout;
        this.logger = logger;
    }

    ProcessingState resolve(Iterable<File> files) {
        ProcessingState processingState = new ProcessingState(files, this.projectLayout);
        while (processingState.isWorkRemaining()) {
            this.processSchemaFile(processingState, processingState.nextFileState());
        }
        Set<FileState> failedFiles = processingState.getFailedFiles();
        if (!failedFiles.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Could not resolve schema definition files:");
            for (FileState fileState : failedFiles) {
                String path = fileState.getPath();
                String fileErrorMessage = fileState.getErrorMessage();
                errorMessage.append(System.lineSeparator()).append("* ").append(path).append(": ").append(fileErrorMessage);
            }
            throw new GradleException(errorMessage.toString());
        }
        return processingState;
    }

    private void processSchemaFile(ProcessingState processingState, FileState fileState) {
        String path = fileState.getPath();
        this.logger.debug("Processing {}, excluding types {}", (Object)path, fileState.getDuplicateTypeNames());
        File sourceFile = fileState.getFile();
        Map<String, Schema> parserTypes = processingState.determineParserTypes(fileState);
        try {
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(parserTypes);
            parser.parse(sourceFile);
            Map<String, Schema> typesDefinedInFile = MapUtils.asymmetricDifference(parser.getTypes(), parserTypes);
            processingState.processTypeDefinitions(fileState, typesDefinedInFile);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processed {}; contained types {}", (Object)path, typesDefinedInFile.keySet());
            } else {
                this.logger.info("Processed {}", (Object)path);
            }
        }
        catch (SchemaParseException ex) {
            String errorMessage = ex.getMessage();
            Matcher unknownTypeMatcher = ERROR_UNKNOWN_TYPE.matcher(errorMessage);
            Matcher duplicateTypeMatcher = ERROR_DUPLICATE_TYPE.matcher(errorMessage);
            if (unknownTypeMatcher.matches()) {
                fileState.setError(ex);
                processingState.queueForDelayedProcessing(fileState);
                this.logger.debug("Found undefined name in {} ({}); will try again", (Object)path, (Object)errorMessage);
            }
            if (duplicateTypeMatcher.matches()) {
                String typeName = duplicateTypeMatcher.group(1);
                if (fileState.containsDuplicateTypeName(typeName)) {
                    throw new GradleException(String.format("Failed to resolve schema definition file %s; contains duplicate type definition %s", path, typeName), (Throwable)ex);
                }
                fileState.setError(ex);
                fileState.addDuplicateTypeName(typeName);
                processingState.queueForProcessing(fileState);
                this.logger.debug("Identified duplicate type {} in {}; will re-process excluding it", (Object)typeName, (Object)path);
            }
            throw new GradleException(String.format("Failed to resolve schema definition file %s", path), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to resolve schema definition file %s", path), (Throwable)ex);
        }
    }
}

