/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.GradleFeatures;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.SourceSet;

class GradleCompatibility {
    GradleCompatibility() {
    }

    static <T> T createExtensionWithObjectFactory(Project project, String extensionName, Class<T> extensionType) {
        if (GradleFeatures.extensionInjection.isSupported()) {
            return (T)project.getExtensions().create(extensionName, extensionType, new Object[0]);
        }
        return (T)project.getExtensions().create(extensionName, extensionType, new Object[]{project.getObjects()});
    }

    static ConfigurableFileCollection createConfigurableFileCollection(Project project) {
        if (GradleFeatures.objectFactoryFileCollection.isSupported()) {
            return project.getObjects().fileCollection();
        }
        Class[] parameterTypes = new Class[]{Object[].class};
        Object[] args = new Object[]{new Object[0]};
        return (ConfigurableFileCollection)GradleCompatibility.invokeMethod(project.getLayout(), "configurableFiles", parameterTypes, args);
    }

    static String getSourcesJarTaskName(SourceSet sourceSet) {
        if (GradleFeatures.getSourcesJarTaskName.isSupported()) {
            return sourceSet.getSourcesJarTaskName();
        }
        return sourceSet.getTaskName(null, "sourcesJar");
    }

    private static <T> T invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] args) {
        try {
            Method method = object.getClass().getMethod(methodName, parameterTypes);
            return (T)method.invoke(object, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to invoke method via reflection", ex);
        }
    }
}

