/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.gradle.api.file.ProjectLayout;

class FileUtils {
    FileUtils() {
    }

    private static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    private static void writeStringToFile(File file, String data, String encoding) throws IOException {
        if (encoding == null) {
            throw new IllegalArgumentException("Must specify encoding");
        }
        try (FileOutputStream out = FileUtils.openOutputStream(file);){
            if (data != null) {
                ((OutputStream)out).write(data.getBytes(encoding));
            }
        }
    }

    static void writeJsonFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile(file, data, "UTF-8");
    }

    static String projectRelativePath(ProjectLayout projectLayout, File file) {
        Path path = file.toPath();
        if (path.isAbsolute()) {
            Path projectDirectoryPath = projectLayout.getProjectDirectory().getAsFile().toPath();
            path = projectDirectoryPath.relativize(path);
        } else {
            path = file.toPath();
        }
        return path.toString();
    }
}

