/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.Strings;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;

class AvroUtils {
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final String EXTENSION_SEPARATOR = ".";
    private static final String UNIX_SEPARATOR = "/";

    private AvroUtils() {
    }

    static String assemblePath(Schema schema) {
        return AvroUtils.assemblePath(schema.getNamespace(), schema.getName(), "avsc");
    }

    static String assemblePath(Protocol protocol) {
        return AvroUtils.assemblePath(protocol.getNamespace(), protocol.getName(), "avpr");
    }

    private static String assemblePath(String namespace, String name, String extension) {
        Strings.requireNotEmpty(name, "Path cannot be assembled for nameless objects");
        ArrayList<String> parts = new ArrayList<String>();
        if (Strings.isNotEmpty(namespace)) {
            parts.add(namespace.replaceAll(Pattern.quote("."), UNIX_SEPARATOR));
        }
        parts.add(name + "." + extension);
        return String.join((CharSequence)UNIX_SEPARATOR, parts);
    }
}

