/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.scanners;

import android.media.AudioManager;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetManager;
import com.twilio.audioswitch.scanners.Scanner;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u00020\u00158\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/twilio/audioswitch/scanners/LegacyAudioDeviceScanner;", "Lcom/twilio/audioswitch/scanners/Scanner;", "audioManager", "Landroid/media/AudioManager;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "bluetoothHeadsetManager", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "(Landroid/media/AudioManager;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;)V", "bluetoothDeviceConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "getBluetoothDeviceConnectionListener$audioswitch_release$annotations", "()V", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "listener", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/twilio/audioswitch/scanners/Scanner$Listener;", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release$annotations", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "isDeviceActive", "", "audioDevice", "Lcom/twilio/audioswitch/AudioDevice;", "start", "stop", "audioswitch_release"})
public final class LegacyAudioDeviceScanner
implements Scanner {
    private final AtomicReference<Scanner.Listener> listener;
    @NotNull
    private final BluetoothHeadsetConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    private final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    private final AudioManager audioManager;
    private final AudioDeviceManager audioDeviceManager;
    private final WiredHeadsetReceiver wiredHeadsetReceiver;
    private final BluetoothHeadsetManager bluetoothHeadsetManager;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getBluetoothDeviceConnectionListener$audioswitch_release$annotations() {
    }

    @NotNull
    public final BluetoothHeadsetConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getWiredDeviceConnectionListener$audioswitch_release$annotations() {
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDeviceActive(@NotNull AudioDevice audioDevice) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        AudioDevice audioDevice2 = audioDevice;
        if (audioDevice2 instanceof AudioDevice.BluetoothHeadset) {
            BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
            if (bluetoothHeadsetManager == null) return false;
            if (bluetoothHeadsetManager.hasActivationError()) return false;
            if (this.bluetoothHeadsetManager.getHeadset(audioDevice.getName()) == null) return false;
            return true;
        }
        if (audioDevice2 instanceof AudioDevice.Earpiece) {
            return true;
        }
        if (audioDevice2 instanceof AudioDevice.Speakerphone) {
            bl = this.audioManager.isSpeakerphoneOn();
            return bl;
        } else {
            if (!(audioDevice2 instanceof AudioDevice.WiredHeadset)) throw new NoWhenBranchMatchedException();
            bl = this.audioManager.isWiredHeadsetOn();
        }
        return bl;
    }

    @Override
    public boolean start(@NotNull Scanner.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener.set(listener);
        BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
        if (bluetoothHeadsetManager != null) {
            bluetoothHeadsetManager.start(this.bluetoothDeviceConnectionListener);
        }
        this.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
        if (this.audioDeviceManager.hasEarpiece()) {
            listener.onDeviceConnected(new AudioDevice.Earpiece(null, 1, null));
        }
        if (this.audioDeviceManager.hasSpeakerphone()) {
            listener.onDeviceConnected(new AudioDevice.Speakerphone(null, 1, null));
        }
        return true;
    }

    @Override
    public boolean stop() {
        BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
        if (bluetoothHeadsetManager != null) {
            bluetoothHeadsetManager.stop();
        }
        this.wiredHeadsetReceiver.stop();
        return true;
    }

    public LegacyAudioDeviceScanner(@NotNull AudioManager audioManager, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothHeadsetManager bluetoothHeadsetManager) {
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        this.audioManager = audioManager;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.bluetoothHeadsetManager = bluetoothHeadsetManager;
        this.listener = new AtomicReference<Object>(null);
        this.bluetoothDeviceConnectionListener = new BluetoothHeadsetConnectionListener(this){
            private final AtomicReference<AudioDevice.BluetoothHeadset> connectedDevices;
            final /* synthetic */ LegacyAudioDeviceScanner this$0;

            public synchronized void onBluetoothHeadsetStateChanged(@Nullable String headsetName) {
                Scanner.Listener listener = (Scanner.Listener)LegacyAudioDeviceScanner.access$getListener$p(this.this$0).get();
                if (headsetName == null) {
                    AudioDevice.BluetoothHeadset it;
                    boolean bl;
                    boolean bl2;
                    AudioDevice.BluetoothHeadset bluetoothHeadset;
                    AudioDevice.BluetoothHeadset newBluetoothHeadset;
                    AudioDevice.BluetoothHeadset bluetoothHeadset2 = this.connectedDevices.get();
                    BluetoothHeadsetManager bluetoothHeadsetManager = LegacyAudioDeviceScanner.access$getBluetoothHeadsetManager$p(this.this$0);
                    AudioDevice.BluetoothHeadset bluetoothHeadset3 = newBluetoothHeadset = bluetoothHeadsetManager != null ? bluetoothHeadsetManager.getHeadset(null) : null;
                    if (Intrinsics.areEqual((Object)newBluetoothHeadset, (Object)bluetoothHeadset2)) {
                        return;
                    }
                    this.connectedDevices.set(newBluetoothHeadset);
                    AudioDevice.BluetoothHeadset bluetoothHeadset4 = bluetoothHeadset2;
                    if (bluetoothHeadset4 != null) {
                        bluetoothHeadset = bluetoothHeadset4;
                        bl2 = false;
                        bl = false;
                        it = bluetoothHeadset;
                        boolean bl3 = false;
                        listener.onDeviceDisconnected(it);
                    }
                    AudioDevice.BluetoothHeadset bluetoothHeadset5 = newBluetoothHeadset;
                    if (bluetoothHeadset5 != null) {
                        bluetoothHeadset = bluetoothHeadset5;
                        bl2 = false;
                        bl = false;
                        it = bluetoothHeadset;
                        boolean bl4 = false;
                        listener.onDeviceConnected(it);
                    }
                } else {
                    AudioDevice.BluetoothHeadset audioDevice = new AudioDevice.BluetoothHeadset(headsetName);
                    this.connectedDevices.set(audioDevice);
                    listener.onDeviceConnected(audioDevice);
                }
            }

            public synchronized void onBluetoothHeadsetActivationError() {
                AudioDevice.BluetoothHeadset audioDevice = new AudioDevice.BluetoothHeadset("Bluetooth");
                ((Scanner.Listener)LegacyAudioDeviceScanner.access$getListener$p(this.this$0).get()).onDeviceDisconnected(audioDevice);
            }
            {
                this.this$0 = this$0;
                this.connectedDevices = new AtomicReference<V>();
            }
        };
        this.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            private final AudioDevice.WiredHeadset audioDevice;
            final /* synthetic */ LegacyAudioDeviceScanner this$0;

            public void onDeviceConnected() {
                ((Scanner.Listener)LegacyAudioDeviceScanner.access$getListener$p(this.this$0).get()).onDeviceConnected(this.audioDevice);
            }

            public void onDeviceDisconnected() {
                ((Scanner.Listener)LegacyAudioDeviceScanner.access$getListener$p(this.this$0).get()).onDeviceDisconnected(this.audioDevice);
            }
            {
                this.this$0 = this$0;
                this.audioDevice = new AudioDevice.WiredHeadset(null, 1, null);
            }
        };
    }

    @Override
    public boolean start(@NotNull Function1<? super AudioDevice, Unit> onDeviceConnected2, @NotNull Function1<? super AudioDevice, Unit> onDeviceDisconnected2) {
        Intrinsics.checkNotNullParameter(onDeviceConnected2, (String)"onDeviceConnected");
        Intrinsics.checkNotNullParameter(onDeviceDisconnected2, (String)"onDeviceDisconnected");
        return Scanner.DefaultImpls.start(this, onDeviceConnected2, onDeviceDisconnected2);
    }

    @Override
    public boolean isDeviceInactive(@NotNull AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        return Scanner.DefaultImpls.isDeviceInactive(this, audioDevice);
    }

    public static final /* synthetic */ AtomicReference access$getListener$p(LegacyAudioDeviceScanner $this) {
        return $this.listener;
    }

    public static final /* synthetic */ BluetoothHeadsetManager access$getBluetoothHeadsetManager$p(LegacyAudioDeviceScanner $this) {
        return $this.bluetoothHeadsetManager;
    }
}

